#!/usr/bin/env bash

SCRIPT_DIR=$(cd $(dirname $0); pwd)
DATA_DIR=${SCRIPT_DIR}/../data
DATABASE_DIR=${SCRIPT_DIR}/../db

if [ ! -d $DATA_DIR ]; then
  echo "ERROR: data フォルダが存在しません"
else
  if find "$DATA_DIR" -type f -name "*.zip" | grep -q .; then
    echo "${DATABASE_DIR} を初期化してデータを登録します"
    rm -fR ${DATABASE_DIR}
    mkdir ${DATABASE_DIR}
    for ZIP in $(find $DATA_DIR -name '*.zip') ; do
      echo "$ZIP を処理します"
      unzip -p ${ZIP} '*.csv' | node ${SCRIPT_DIR}/setup.js ${DATABASE_DIR}
    done
    echo "${DATABASE_DIR} への登録が完了しました"
  else
    echo "ERROR: data フォルダに zip が存在しません"    
  fi
fi



