$SCRIPT_DIR = Split-Path -Parent $MyInvocation.MyCommand.Path
$DATA_DIR = Join-Path $SCRIPT_DIR "..\data"
$DATABASE_DIR = Join-Path $SCRIPT_DIR "..\db"
$SETUP_JS = Join-Path $SCRIPT_DIR "setup.js"

Write-Host "Step1. Unzip"
$ZIP_FILES = Get-ChildItem -Path $DATA_DIR -Filter "*.zip" -Recurse
foreach ($ZIP in $ZIP_FILES) {
  Write-Host $ZIP.FullName
  Expand-Archive -Path $ZIP.FullName -DestinationPath $DATA_DIR -Force
}

Write-Host "Step2. Create Database Directory"
Remove-Item -Recurse -Force $DATABASE_DIR -ErrorAction SilentlyContinue
New-Item -ItemType Directory -Path $DATABASE_DIR | Out-Null

Write-Host "Step3. Consume CSV"
$CSV_FILES = Get-ChildItem -Path $DATA_DIR -Filter "*.csv" -Recurse
foreach ($CSV in $CSV_FILES) {
  Write-Host $CSV.FullName
  Get-Content $CSV.FullName | node $SETUP_JS $DATABASE_DIR
  Remove-Item -Force $CSV.FullName -ErrorAction SilentlyContinue
}

Write-Host "Done."
