const Papa = require("papaparse");
const format = require("./format");
const levelup = require("levelup");
const leveldown = require("leveldown");

const readline = require("readline");

const DATABASE = process.argv[2];

const SIZE = 10000;

(async function () {
  const db = levelup(leveldown(DATABASE));

  const promises = [];
  let operations = [];
  const count = { total: 0, skip: 0, good: 0, invalid: 0 };
  try {
    await db.open();

    console.log("database opened");
    const stream = readline.createInterface({
      input: process.stdin,
    });

    for await (const line of stream) {
      const f = Papa.parse(line).data[0];
      const data = format(f);
      count.total++;
      if (!data) {
        count.skip++;
        continue;
      }
      count.good++;
      operations.push({ type: "put", key: data.legalEntityNumber, value: JSON.stringify(data) });
      if (operations.length === SIZE) {
        promises.push(db.batch(operations));
        operations = [];
        console.log(count);
      }
    }
    if (operations.length != 0) {
      promises.push(db.batch(operations));
      operations = [];
      console.log(count);
    }
    await Promise.all(promises);
  } catch (e) {
    console.log(e);
  } finally {
    await db.close();
    console.log("database closed");
  }
})();
