// 0	一連番号	sequenceNumber
// 1	法人番号	corporateNumber
// 2	処理区分	process
// 3	訂正区分	correct
// 4	更新年月日	updateDate
// 5	変更年月日	changeDate
// 6	商号又は名称	name
// 7	"商号又は名称イメージID"	nameImageId
// 8	法人種別	kind
// 9	"国内所在地（都道府県）"	prefectureName
// 10	"国内所在地（市区町村）"	cityName
// 11	"国内所在地（丁目番地等）"	streetNumber
// 12	"国内所在地イメージID"	addressImageId
// 13	都道府県コード	prefectureCode
// 14	市区町村コード	cityCode
// 15	郵便番号	postCode
// 16	国外所在地	addressOutside
// 17	"国外所在地イメージID"	"addressOutsideImageId"
// 18	"登記記録の閉鎖等年月日"	closeDate
// 19	登記記録の閉鎖等の事由	closeCause
// 20	"承継先法人番号"	"successorCorporateNumber"
// 21	変更事由の詳細	changeCause
// 22	法人番号指定年月日	assignmentDate
// 23	最新履歴	latest
// 24	商号又は名称（英語表記）	enName
// 25	国内所在地（都道府県）(英語表記）	enPrefectureName
// 26	"国内所在地（市区町村丁目番地等）（英語表記）"	enCityName
// 27	国外所在地（英語表記）	enAddressOutside
// 28	フリガナ	furigana
// 29	検索対象除外	hihyoji

const tidy = function (src) {
  if (src === undefined) return undefined;
  else if (Array.isArray(src)) {
    const dst = src.map((x) => tidy(x)).filter((x) => x !== undefined);
    if (dst.length === 0) return undefined;
    if (dst.length === 1) return dst[0];
    return dst;
  } else if (typeof src === "string") {
    return src.length === 0 ? undefined : src;
  } else {
    const dst = {};
    for (const [k, v] of Object.entries(src)) {
      const x = tidy(v);
      if (x !== undefined) dst[k] = x;
    }
    return Object.keys(dst).length === 0 ? undefined : dst;
  }
};

const localGovernmentCode = function (s) {
  if (s.match(/^[0-9]{5}$/)) {
    const a =
      parseInt(s.substring(0, 1)) * 6 +
      parseInt(s.substring(1, 2)) * 5 +
      parseInt(s.substring(2, 3)) * 4 +
      parseInt(s.substring(3, 4)) * 3 +
      parseInt(s.substring(4, 5)) * 2;
    const b = a % 11;
    const c = 11 - b;
    const d = c % 10;
    return s + d;
  }
  return s;
};

module.exports = function (f) {
  if (!f || f[1] === undefined) return null;

  const localAddress = tidy({
    localGovernmentCode: localGovernmentCode(f[13] + f[14]),
    //streetAddressId: "",
    prefecture: f[9],
    cityAndCounty: f[10],
    streetAddressAndCityBlock: f[11],
    //buildingNameEtc: "",
    fullAddress: f[9] + f[10] + f[11],
    postalCode: f[15],
    //country: "",
    //streetAddress: "",
    //cityBlock: "",
    //prefectureKana: "",
    //cityAndCountyKana: "",
    //streetAddressAndCityBlockKana: "",
    //buildingNameEtcKana: "",
    //fullAddressKana: "",
    prefectureEn: f[25],
    //cityAndCountyEn: f[26],
    //streetAddressAndCityBlockEn: f[27],
    //buildingNameEtcEn: "",
    fullAddressEn: f[26]
      .split(",")
      .map((a) => a.trim())
      .concat(f[25])
      .filter((a) => a.length > 0)
      .join(", "),
    //latitudeOfRepresentativePoint: "",
    //longitudeOfRepresentativePoint: "",
    //coordinateReferenceSystem: "",
    //coordinateReferenceSystemCode: "",
    //county: "",
    //city: "",
    //ward: "",
    //largerSectionTown: "",
    //chome: "",
    //smallAdministrativeUnit: "",
    //displayedAddressFlag: "",
    //areaCode: "",
    //residenceNumber: "",
    //landNumber: "",
    //buildingName: "",
    //floorName: "",
    //locatorName: "",
  });

  const globalAddress = tidy({
    fullAddress: f[16],
    fullAddressEn: f[27],
  });

  const template = {
    legalEntityNumber: f[1],
    //idGroup: [{}],
    tradeName: f[6],
    tradeNameKana: f[28].normalize("NFKC"),
    tradeNameEn: f[24],
    categoryOfOrganization: f[8],
    //alternateName: [""],
    activityStatus: f[18] + f[19],
    //description: "",
    //webSiteUrl: "https://",
    //numberOfCompanyEmployee: 0,
    //representative: {},
    //positionOfRepresentative: "",
    //dateOfEstablishment: "yyyy-mm-dd",
    //categoryOfBusiness: [""],
    //businessPlaceInformation: [{}],
    contactPointInformation: {
      contactPointUrl:
        "https://www.houjin-bangou.nta.go.jp/henkorireki-johoto.html?selHouzinNo=" + f[1],
    },
    positionOfOrganizationTypeInName: (function () {
      if (f[8] === "301" && f[6].startsWith("株式会社")) return "前株";
      if (f[8] === "301" && f[6].endsWith("株式会社")) return "後株";
      return "";
    })(),
    relatedOrganization: [
      (function () {
        if (f[20] !== "")
          return {
            role: { codeType: "組織間の関係性", code: "承継先法人" },
            legalEntityNumber: f[20],
          };
        return undefined;
      })(),
    ],
    //numberOfRegularEmployee: 0,
    //numberOfEmployee: 0,
    //facilityDescription: "",
    //yearOfEstablishment: "",
    //startDateOfFiscalYear: "mm-dd",
    //capital_JPY: 0,
  };

  //return template;

  const fill = (target, keys) => {
    keys.forEach((key) => {
      if (target[key] === undefined) target[key] = "";
    });
    return target;
  };

  const answer = tidy(template);

  (function (address) {
    if (!address) {
      console.error("address not found", f);
      process.exit(1);
    }

    if (address.localGovernmentCode) {
      if (address.prefecture && address.cityAndCounty) {
        fill(address, ["streetAddressAndCityBlock", "buildingNameEtc"]);
        answer.registeredAddress_MP04 = address;
      } else {
        fill(address, ["streetAddressAndCityBlock", "buildingNameEtc"]);
        answer.registeredAddress_MP05 = address;
      }
    } else if (address.fullAddress) {
      address.country = "XXX";
      address.postalCode = "UNKNOWN";
      answer.registeredAddress_MP07 = address;
    } else if (address.fullAddressEn) {
      address.country = "XXX";
      address.postalCode = "UNKNOWN";
      address.fullAddress = address.fullAddressEn;
      answer.registeredAddress_MP07 = address;
    } else {
      console.error("Unreachable");
      console.error(address, answer);
    }
  })(localAddress || globalAddress);

  fill(answer, ["tradeNameKana"]);

  return answer;
};
