const spawn = require("child_process").spawn;
const test = require("tape");
const PORT = "8080";
const ENDPOINT = `http://localhost:${PORT}`;
const OK = `${ENDPOINT}/1430001000005`;
const NOT_FOUND = `${ENDPOINT}/2430001000005`;
const INVALID = `${ENDPOINT}/14300010000051430001000005`;

const server = spawn("node", ["bin/server.js", PORT]);

test("server", async (t) => {
  try {
    let ok = false;
    let retry = 0;
    while (!ok) {
      retry++;
      await new Promise((resolve) => setTimeout(resolve, 500));
      ok = (await fetch(ENDPOINT)).ok;
      if (retry >= 100) {
        t.end(`${retry} のリトライをしましたがサーバの反応がありません`);
        return;
      }
    }

    let res;

    res = await fetch(OK);
    t.equal(res.status, 200, "有効な GET リクエストに対して 200 を返すこと");
    t.equal(res.headers.get("Access-Control-Allow-Origin"), "*");

    res = await fetch(INVALID);
    t.equal(res.status, 400, "不正な GET リクエストを 400 でリジェクトすること");
    t.equal(res.headers.get("Access-Control-Allow-Origin"), "*");

    res = await fetch(NOT_FOUND);
    t.equal(res.status, 404, "存在しない法人番号への GET リクエストを 404 でリジェクトすること");
    t.equal(res.headers.get("Access-Control-Allow-Origin"), "*");

    res = await fetch(OK, { method: "HEAD" });
    t.equal(res.status, 405, "HEAD リクエストを 405 でリジェクトすること");
    t.equal(res.headers.get("Access-Control-Allow-Origin"), "*");

    res = await fetch(OK, { method: "POST" });
    t.equal(res.status, 405, "POST リクエストを 405 でリジェクトすること");
    t.equal(res.headers.get("Access-Control-Allow-Origin"), "*");
  } finally {
    server.kill("SIGTERM");
  }
  t.end();
});
