const test = require("tape");
const format = require("../tools/format.js");

test("format", function (t) {
  const src = [
    "1",
    "1000012160153",
    "01",
    "1",
    "2018-04-02",
    "2015-10-05",
    "釧路検察審査会",
    "",
    "101",
    "北海道",
    "釧路市",
    "柏木町４－７",
    "",
    "01",
    "206",
    "0850824",
    "",
    "",
    "",
    "",
    "",
    "",
    "2015-10-05",
    "1",
    "Kushiro Committee for the Inquest of Prosecution",
    "Hokkaido",
    "4-7, Kashiwagicho, Kushiro shi",
    "",
    "クシロケンサツシンサカイ",
    "0",
  ];
  const dst = {
    legalEntityNumber: "1000012160153",
    tradeName: "釧路検察審査会",
    tradeNameKana: "クシロケンサツシンサカイ",
    tradeNameEn: "Kushiro Committee for the Inquest of Prosecution",
    categoryOfOrganization: "101",
    contactPointInformation: {
      contactPointUrl:
        "https://www.houjin-bangou.nta.go.jp/henkorireki-johoto.html?selHouzinNo=1000012160153",
    },
    registeredAddress_MP04: {
      localGovernmentCode: "012068",
      prefecture: "北海道",
      cityAndCounty: "釧路市",
      streetAddressAndCityBlock: "柏木町４－７",
      fullAddress: "北海道釧路市柏木町４－７",
      postalCode: "0850824",
      prefectureEn: "Hokkaido",
      fullAddressEn: "4-7, Kashiwagicho, Kushiro shi, Hokkaido",
      buildingNameEtc: "",
    },
  };
  t.deepEqual(format(src), dst, "フォーマット関数がエラーなく動作すること");
  t.end();
});
