const fs = require("fs");
const test = require("tape");
const levelup = require("levelup");
const leveldown = require("leveldown");
const Ajv = require("ajv");
const db = levelup(leveldown(`${__dirname}/../db`));

const ajv = new Ajv({ allErrors: true, removeAdditional: false });
const validate = ajv.compile(
  JSON.parse(fs.readFileSync(`${__dirname}/../schema/LegalEntity.schema.json`, "UTF-8"))
);

test("test-schema", async function (t) {
  const count = { total: 0, good: 0, fail: 0, error: 0 };
  const failed = [];
  const errors = [];
  for await (const [key, value] of db.iterator({ valueAsBuffer: false, keyAsBuffer: false })) {
    count.total++;
    try {
      const j = JSON.parse(value);
      if (validate(j)) count.good++;
      else {
        count.fail++;
        failed.push(key);
      }
    } catch (e) {
      count.error++;
      errors.push(key);
    }
  }
  t.ok(count.total > 0, `DB に 1件以上のレコードが登録されていること : ${count.total}`);
  t.equal(
    count.good,
    count.total,
    `LegalEntity.schema.json に適合するレコード数が DB の総レコード数  ${count.total} に一致すること`
  );
  t.equal(count.fail, 0, `LegalEntity.schema.json に適合しないレコードが 0 件であること`);
  t.equal(count.error, 0, `非JSONのレコードが 0 件であること`);
  t.deepEqual(failed, [], `LegalEntity.schema.json に適合しないレコードのキーは空集合であること`);
  t.deepEqual(errors, [], `非JSONのレコードのキーは空集合であること`);
  t.end();
});
