const { spawnSync } = require("child_process");
const test = require("tape");
const OK = `1430001000005`;
const NOT_FOUND = `2430001000005`;
const INVALID = `14300010000051430001000005`;

test("cli", async (t) => {
  const good = spawnSync("node", ["bin/cli.js", OK]);
  t.equal(good.status, 0, "正常系(有効な法人番号)のステータスコードは 0 であること");
  t.doesNotThrow(
    () => JSON.parse(good.stdout.toString()),
    "正常系(有効な法人番号)の出力は JSON としてパースできること"
  );

  const fail = spawnSync("node", ["bin/cli.js", NOT_FOUND]);
  t.equal(fail.status, 1, "異常系(存在しない法人番号)のステータスコードは 1 であること");
  t.throws(
    () => JSON.parse(fail.stdout.toString()),
    "異常系(存在しない法人番号)の出力は JSON としてパースできないこと"
  );

  const invalid = spawnSync("node", ["bin/cli.js", INVALID]);
  t.equal(invalid.status, 1, "異常系(無効な法人番号)のステータスコードは 1 であること");
  t.throws(
    () => JSON.parse(invalid.stdout.toString()),
    "異常系(無効な法人番号)の出力は JSON としてパースできないこと"
  );

  const none = spawnSync("node", ["bin/cli.js"]);
  t.equal(none.status, 1, "異常系(引数なし)のステータスコードは 1 であること");
  t.throws(
    () => JSON.parse(none.stdout.toString()),
    "異常系(引数なし)の出力は JSON としてパースできないこと"
  );

  t.end();
});
