const levelup = require("levelup");
const leveldown = require("leveldown");

(async function () {
  if (process.argv.length !== 3 || !process.argv[2].match(/^[0-9]{13}$/)) {
    console.error("Usage: node main.js [法人番号(13桁数字)]");
    process.exit(1);
  }
  const key = process.argv[2];
  const db = levelup(leveldown(`${__dirname}/../db`));
  try {
    const str = await db.get(key, {
      asBuffer: false,
    });
    console.log(JSON.stringify(JSON.parse(str), null, 2));
  } catch (e) {
    console.error("Error: " + e.message);
    process.exit(1);
  } finally {
    try {
      await db.close();
    } catch (e) {}
  }
})();
