# legal-entity

法人情報のための GIF コンポーネントツール

- [国税庁法人番号公表サイト](https://www.houjin-bangou.nta.go.jp/) で提供されている CSV 形式・Unicode のデータを GIF の LegalEntity (JSON) に変換します
- 変換結果を [LevelDB](https://github.com/google/leveldb) にストアします
- LevelDB にアクセスするための WebAPI および コマンドラインインターフェイスを提供します

以下のような CSV が

```input.csv
1,1000012160153,01,1,2018-04-02,2015-10-05,釧路検察審査会,,101,北海道,釧路市,柏木町４－７,,01,206,0850824,,,,,,,2015-10-05,1,Kushiro Committee for the Inquest of Prosecution,Hokkaido,4-7, Kashiwagicho, Kushiro shi,,クシロケンサツシンサカイ,0
```

以下のような JSON に変換されます

```output.json
{
  "legalEntityNumber": "1000012160153",
  "tradeName": "釧路検察審査会",
  "tradeNameKana": "クシロケンサツシンサカイ",
  "tradeNameEn": "Kushiro Committee for the Inquest of Prosecution",
  "categoryOfOrganization": "101",
  "contactPointInformation": {
    "contactPointUrl": "https://www.houjin-bangou.nta.go.jp/henkorireki-johoto.html?selHouzinNo=1000012160153"
  },
  "registeredAddress_MP04": {
    "localGovernmentCode": "012068",
    "prefecture": "北海道",
    "cityAndCounty": "釧路市",
    "streetAddressAndCityBlock": "柏木町４－７",
    "fullAddress": "北海道釧路市柏木町４－７",
    "postalCode": "0850824",
    "prefectureEn": "Hokkaido",
    "fullAddressEn": "4-7, Kashiwagicho, Kushiro shi, Hokkaido",
    "buildingNameEtc": ""
  }
}
```

# 利用者向け情報

## インストール (Bash)

ここでは `dev-gif-component-tools-legal-entity-1.0.0.tgz` が `${SOMEWHERE}` フォルダにあるものとします。

以下の手順でインストール～ DB 構築～テストが完了します。

```
$ mkdir work
$ cd work
$ tar xvzf ${SOMEWHERE}/dev-gif-component-tools-legal-entity-1.0.0.tgz
$ cd dev-gif-component-tools-legal-entity-1.0.0
$ npm install
$ npm run setup
$ npm test
```

なお、`dev-gif-component-tools-legal-entity-1.0.0.tgz` には
[法人番号公表サイト:基本３情報ダウンロード](https://www.houjin-bangou.nta.go.jp/download/) の
サンプルデータ（令和４年４月版）に含まれる
`k-sample-dl-r0404/01_ダウンロード機能/01_全件データ/02_CSV・Unicode` 配下の
zip ファイル 48 件を同梱しています。
このサンプルデータ群には合計 5126 件のレコードが含まれます。

## インストール (PowerShell)

Windows 10/11 の PowerShell でのインストール方法です。

**重要** 事前に [PowerShell7.x](https://learn.microsoft.com/ja-jp/powershell/scripting/install/installing-powershell-on-windows?view=powershell-7.5) および [Node.js / npm](https://nodejs.org/ja/download) のインストールが必要です。

ここでは `C:\demo` が作業フォルダとして作成され、同フォルダに
`dev-gif-component-tools-legal-entity-1.0.0.tgz` が配備されているものとします。

インストールした PowerShell7.x にて、以下の手順でインストール～ DB 構築が完了します。

※ `npm run setup` の代わりに `.\tools\setup.ps1` を実行します

```
PS C:\Users\John> cd C:\demo
PS C:\demo> tar xvzf .\dev-gif-component-tools-legal-entity-1.0.0.tgz
(略)
PS C:\demo> cd .\dev-gif-component-tools-legal-entity-1.0.0\
PS C:\demo\dev-gif-component-tools-legal-entity-1.0.0> npm install
(略)
PS C:\demo\dev-gif-component-tools-legal-entity-1.0.0> .\tools\setup.ps1
(略)
PS C:\demo\dev-gif-component-tools-legal-entity-1.0.0>
```

**トラブルシューティング** `.\tools\setup.ps1` の実行に当たって以下のように実行権限エラーが発生する場合があります。

```
PS C:\demo\dev-gif-component-tools-legal-entity-1.0.0> .\tools\setup.ps1
.\tools\setup.ps1: File C:\demo\dev-gif-component-tools-legal-entity-1.0.0\tools\setup.ps1 cannot be loaded because running scripts is disabled on this system. For more information, see about_Execution_Policies at https://go.microsoft.com/fwlink/?LinkID=135170.
PS C:\demo\dev-gif-component-tools-legal-entity-1.0.0>
```

これは PowerShell においてローカルの `*.ps1` ファイルを実行する権限が付与されていないことが原因です。
このような場合、以下のように `Set-ExecutionPolicy -Scope CurrentUser RemoteSigned` を実行することで
権限を付与してから実行してください。

```
PS C:\demo\dev-gif-component-tools-legal-entity-1.0.0> Set-ExecutionPolicy -Scope CurrentUser RemoteSigned
PS C:\demo\dev-gif-component-tools-legal-entity-1.0.0> .\tools\setup.ps1
Step1. Unzip
C:\demo\dev-gif-component-tools-legal-entity-1.0.0\data\01_hokkaido_all_20170428.zip
C:\demo\dev-gif-component-tools-legal-entity-1.0.0\data\02_aomori_all_20170428.zip
(略)
C:\demo\dev-gif-component-tools-legal-entity-1.0.0\data\99_kokugai_all_20170428.csv
database opened
{ total: 1, skip: 0, good: 1, invalid: 0 }
database closed
Done.
PS C:\demo\dev-gif-component-tools-legal-entity-1.0.0>
```

## コマンドラインインターフェイス

`node bin/cli.js [13桁法人番号]` を実行することで、
指定された法人番号の GIF (JSON) が出力されます。

```
$ cd dev-gif-component-tools-legal-entity-1.0.0
$ node bin/cli.js 1430001000005
{
  "legalEntityNumber": "1430001000005",
  "tradeName": "株式会社０００５",
  "categoryOfOrganization": "301",
  "contactPointInformation": {
    "contactPointUrl": "https://www.houjin-bangou.nta.go.jp/henkorireki-johoto.html?selHouzinNo=1430001000005"
  },
  "positionOfOrganizationTypeInName": "前株",
  "registeredAddress_MP04": {
    "localGovernmentCode": "011011",
    "prefecture": "北海道",
    "cityAndCounty": "札幌市中央区",
    "streetAddressAndCityBlock": "北一条西２２丁目３番３２号",
    "fullAddress": "北海道札幌市中央区北一条西２２丁目３番３２号",
    "postalCode": "0640821",
    "buildingNameEtc": ""
  },
  "tradeNameKana": ""
}
$
```

## WebAPI

### サーバの起動方法 (Bash / PowerShell 共通)

以下の手順で `8080` 番ポートにサーバが起動します。

```
$ cd dev-gif-component-tools-legal-entity-1.0.0
$ npm start

> @dev-gif-component-tools/legal-entity@1.0.0 start
> node bin/server.js 8080

@gif-component-tools/legal-entity server is running on port 8080
```

サーバを停止するには Ctrl-C を入力してください。

### 利用方法

`http://localhost:8080/${13桁法人番号}` に GET リクエストを発行することで、
指定された法人番号の GIF (JSON) が出力されます。

```
$ curl http://localhost:8080/1430001000005
{
  "legalEntityNumber": "1430001000005",
  "tradeName": "株式会社０００５",
  "categoryOfOrganization": "301",
  "contactPointInformation": {
    "contactPointUrl": "https://www.houjin-bangou.nta.go.jp/henkorireki-johoto.html?selHouzinNo=1430001000005"
  },
  "positionOfOrganizationTypeInName": "前株",
  "registeredAddress_MP04": {
    "localGovernmentCode": "011011",
    "prefecture": "北海道",
    "cityAndCounty": "札幌市中央区",
    "streetAddressAndCityBlock": "北一条西２２丁目３番３２号",
    "fullAddress": "北海道札幌市中央区北一条西２２丁目３番３２号",
    "postalCode": "0640821",
    "buildingNameEtc": ""
  },
  "tradeNameKana": ""
}
$
```

また、ウェブブラウザで <http://localhost:8080/> を開くと WebAPI 動作確認用の HTML が表示されます。

![legal-entity web api フロントページ](img/legal-entity-web.png)

# 開発者向け情報

## 全国版データへの切り替え

<https://www.houjin-bangou.nta.go.jp/download/zenken/> より必要なデータをダウンロードします。

開発時点では以下のデータが利用可能でした。

- 形式: CSV 形式 Unicode
- 地域: 全国 (zip 235MB)
- 更新: 令和 6 年 10 月 31 日更新
- 名前: 00_zenkoku_all_20241031.zip

以下の手順で `data` フォルダ配下の zip ファイルを差し替えることで
全国版データへの切り替え～ DB 再構築が可能です。

```
$ cd dev-gif-component-tools-legal-entity-1.0.0
$ rm -fR data
$ cp ${SOMEWHERE}/00_zenkoku_all_20241031.zip data
$ npm run setup
```

なお、全国版データは 500 万件以上のデータを含むため、
`npm run setup` や `npm test` にかかる時間が増大します。
環境によっては数十分～数時間がかかる場合があるのでご注意ください。

## Test

### test/test-format.js

`tools/format.js` に対するテストです。
ライブラリのインストールが適切か、
サンプルデータ (CSV) を所定の JSON に変換できるかどうかをテストします。

### test/test-db.js

`tools/setup.sh` によって DB を構築してから実施するテストです。
DB に含まれる全レコードについて `schema/LegalEntity.schema.json` に対する
適合が検査されます。

### test/test-server.js

`tools/setup.sh` によって DB を構築してから実施するテストです。
テスト内でサーバを起動し、サーバに対して GET / HEAD / POST のリクエストを発行し、所定のレスポンスコードが返却されるかどうかを検査します。

### test/test-cli.js

`tools/setup.sh` によって DB を構築してから実施するテストです。
テスト内で `bin/cli.js` を実行し、所定のシグナル／結果文字列が返却されるかどうかが検査されます。

(以上)
