import buble from "@rollup/plugin-buble";
import { nodeResolve } from "@rollup/plugin-node-resolve";
import commonjs from "@rollup/plugin-commonjs";
import terser from "@rollup/plugin-terser";
import json from "@rollup/plugin-json";

export default {
  input: "main.js",
  output: {
    file: "dist/bundle.js",
    format: "iife",
    name: "Bundle",
    plugins: [terser()],
  },
  plugins: [
    json(),
    commonjs(),
    nodeResolve(),
    buble({
      transforms: { forOf: false },
    }),
  ],
};
