# demo

GIF コンポーネントツールの動作確認用サンプル

- 利用者向けに Web ブラウザ上で動作する動作確認用サンプルを提供します
- 開発者向けに各コンポーネントを利用する方法を提供します

# 利用者向け情報

## サーバの起動

`dist` フォルダの配下のファイル群をウェブサーバに配備することで動作します。

以下はウェブサーバとして [superstatic](https://www.npmjs.com/package/superstatic) を使用する場合の実行例です。

```
$ mkdir work
$ cd work
$ tar xvzf ${SOMEWHERE}/dev-gif-component-tools-demo-1.0.0.tgz
$ cd dev-gif-component-tools-demo-1.0.0
$ npm install
$ npm start

> @dev-gif-component-tools/demo@1.0.0 start
> superstatic dist

Superstatic started.
Visit http://localhost:3474 to view your app.

```

サーバを停止するには Ctrl-C を入力してください。

また、法人番号による情報補完機能を使うには
LegalEntity WebAPI が 8080 ポートで起動していることが求められます。
詳しくは LegalEntity の README.md を参照してください。

## 利用方法

### Step1. 初期画面

ウェブブラウザで `dist/index.html` に相当するファイルを開きます。
`npm start` で起動した場合には <http://localhost:3474/> になります。

以下のような GUI が表示されます。

![demo-01](img/demo-01.png)

※ 実行環境によっては起動～ GUI 表示までに時間がかかる場合があります

Input 欄に任意の GIF (JSON) を入力し、【検証する】【正規化する】ボタンを押すと
Output 欄に検証・正規化の結果が表示される、というのが基本動作です。
エラーが発生する場合には Output 欄の下部に詳細なエラーが表示されます。

※ 「詳細なエラー」は機械処理用のものであり、情報量が多いことに注意してください

### Step2. 正常系サンプル

【サンプル】プルダウンからさまざまなサンプルデータをロードすることができます。

以下は先頭のサンプルを選択した場合です。Input 欄に JSON が転記されます。

![demo-02](img/demo-02.png)

この状態で【検証する】ボタンを押すことで Output 欄に検証結果 `この JSON は valid です` が表示されます。

![demo-03](img/demo-03.png)

### Step3. 異常系サンプル

【サンプル】から異常系サンプルを選択し、
【検証する】ボタンを押すと
Output 欄に検証結果 `この JSON は valid ではありません` が表示されます。また、Output の下部には詳細なエラーが表示されます。

![demo-04](img/demo-04.png)

このような場合、【正規化する】ボタンを押すことで
正規化が試行されます。

![demo-05](img/demo-05.png)

この事例では氏名の半角カナが全角カナに、全角英字が半角英字に変換されています。 Output の下部には詳細なエラーと正規化された文字列の情報が表示されます。

## Step4. 法人情報のロード

【法人番号】フィールドに 13 桁法人番号が入力された状態で【読み込み】ボタンを押すことで、Input 欄に当該法人番号に対応する GIF (JSON) が読み込まれます。

![demo-06](img/demo-06.png)

なお、ここでロードされる法人情報は LegalEntity WebAPI (8080 ポート) から入手可能なものに限ります。

## 応用: スキーマの切り替え

画面右上【スキーマ】プルダウンでは、使用するスキーマを切り替えることができます。

デフォルトは `all` ですが、これは GIF のすべてのクラスの JSON を検査することができるスキーマです。汎用性は高いですがサイズが大きく、起動時に時間がかかる場合があります。

`Event` や `Person` といったスキーマは、そのクラス専用に整備されたスキーマです。サイズは最小限で比較的ロードに時間がかかりません。検証対象のクラスが事前に決まっているユースケースでは有効です。

# 開発者向け情報

## インストール～ブラウザバンドルの構築

`demo` はウェブブラウザの JavaScript 実行環境で動作します。ここでは Node.js 用に記述された `util` や `validator` 等をブラウザで動作するようにビルドする手順を解説します。

ここでは `${SOMEWHERE}` フォルダに以下の 3 ファイルがあるものとします。

- dev-gif-component-tools-demo-1.0.0.tgz
- dev-gif-component-tools-util-1.0.0.tgz
- dev-gif-component-tools-validator-1.0.0.tgz

以下の手順で `dist/bundle.js` が生成されます。

```
$ mkdir work
$ cd work
$
$ tar xvzf ${SOMEWHERE}/dev-gif-component-tools-util-1.0.0.tgz
$ pushd dev-gif-component-tools-util-1.0.0
$ npm install
$ popd
$ mv dev-gif-component-tools-util-1.0.0 util
$
$ tar xvzf ${SOMEWHERE}/dev-gif-component-tools-validator-1.0.0.tgz
$ pushd dev-gif-component-tools-validator-1.0.0
$ npm install
$ popd
$ mv dev-gif-component-tools-validator-1.0.0 validator
$
$ tar xvzf ${SOMEWHERE}/dev-gif-component-tools-demo-1.0.0.tgz
$ cd dev-gif-component-tools-demo-1.0.0
$ npm install
$ npm run build

> @dev-gif-component-tools/demo@1.0.0 build
> rollup -c


main.js → dist/bundle.js...
created dist/bundle.js in 2.8s
$
```

## dist/bundle.js の利用

dist/bundle.js には以下の 4 つのコンポーネントが含まれています。

### localize_ja

Ajv のエラーメッセージを日本語化するために、
[ajv-i18n](https://www.npmjs.com/package/ajv-i18n) の
`ajv-i18n/localize/ja` が `localize_ja` としてバンドルされます。

以下のように Ajv の validate 関数の保持する errors を渡して実行することで
errors に含まれるエラーメッセージが日本語化されます。

```localize_ja.js
if(!validate(data)){
    localize_ja(validate.errors);
}
```

### util

`@dev-gif-component-tools/util` が `util` としてバンドルされます。
Validator に対してカスタムフォーマットをセットする目的で利用されます。

### Validator

`@dev-gif-component-tools/validator` が `Validator` としてバンドルされます。

以下のように ajv インスタンス、JSON Schema、 `util` を渡して
Validator のインスタンスを生成して利用します。

```
  const validator = new Validator(new ajv7({ allErrors: true }), schema, util);
```

なお、ajv については公式のブラウザ用ビルドがあるため、それを利用することとし、バンドルには含みません。

- <https://ajv.js.org/guide/environments.html>
- <https://cdnjs.com/libraries/ajv>

### jsonpointer

[jsonpointer](https://www.npmjs.com/package/jsonpointer) が `jsonpointer` としてバンドルされます。

`jsonpointer` は `Validator` の依存ライブラリであり、
暗黙のうちにバンドルされ内部的に利用されますが、
デバッグ目的での直接利用を想定してバンドルしています。

(以上)
