const test = require("tape");
const Ajv = require("ajv");
const fs = require("fs");
const mock = require("../lib/mock.js");

const ajv = new Ajv({ allErrors: true });
for (const [format, a] of Object.entries(mock)) {
  ajv.addFormat(format, (s) => {
    try {
      a.validate(s);
      return true;
    } catch (e) {
      return false;
    }
  });
}

test("schema", function (t) {
  for (const schema of fs
    .readdirSync(`${__dirname}/../schema`)
    .filter((a) => a.endsWith(".json"))) {
    const validate = ajv.compile(
      JSON.parse(fs.readFileSync(`${__dirname}/../schema/${schema}`, "UTF-8"))
    );
    for (const file of fs.readdirSync(`${__dirname}`).filter((a) => {
      return (
        a.endsWith(".json") && (schema.startsWith("all.") || schema.startsWith(a.split(".")[0]))
      );
    })) {
      const json = JSON.parse(fs.readFileSync(`${__dirname}/${file}`, "UTF-8"));
      const result = validate(json);
      if (file.endsWith(".pass.json")) {
        t.ok(result, `${schema} vs ${file}`);
        if (result !== true) console.log(validate.errors);
      }
      if (file.endsWith(".fail.json")) t.notOk(result, `${schema} vs ${file}`);
    }
  }
  t.end();
});
