const test = require("tape");
const Ajv = require("ajv");
const fs = require("fs");
const mock = require("../lib/mock.js");

/*const createCustomFormats = function (json) {
  const formats = new Set();
  const dig = function (e) {
    if (Array.isArray(e)) e.forEach((a) => dig(a));
    else if (typeof e === "object") {
      Object.values(e).forEach((a) => dig(a));
      if (e.format !== undefined) formats.add(e.format);
    }
  };
  dig(json);
  return formats;
};*/

test("compile", function (t) {
  const schemas = fs
    .readdirSync(`${__dirname}/../schema`)
    .filter((a) => a.endsWith(".schema.json"));

  for (const schema of schemas) {
    //}.filter((a) => !a.endsWith(".semantic.schema.json"))) {
    t.doesNotThrow(
      () => {
        const ajv = new Ajv({ allErrors: true });
        for (const [format, a] of Object.entries(mock)) {
          ajv.addFormat(format, (s) => {
            try {
              a.validate(s);
              return true;
            } catch (e) {
              return false;
            }
          });
        }
        const json = JSON.parse(fs.readFileSync(`${__dirname}/../schema/${schema}`, "UTF-8"));
        ajv.compile(json);
      },
      undefined,
      schema
    );
  }

  t.end();
});
