# schema

GIF コンポーネントツールのための JSON Schema 整備

# JSON Schema

## schema/all.schema.json

- 任意の GIF JSON を validate することを目的とした汎用 JSON Schema です
- リテラルは type / enum / pattern のみで判定されます

## schema/${className}.schema.json

- 特定のクラスの GIF JSON を validate することを目的とした JSON Schema です
- リテラルは type / enum / pattern のみで判定されます

## schema/all.semantic.schema.json

- 任意の GIF JSON を validate することを目的とした汎用 JSON Schema です
- リテラルは format で判定されます
- format にはプロパティ名がアサインされます
- 動作のためには使用する JSON Schema Validator に対してカスタム Format の登録が必要です

## schema/${className}.schema.json

- 特定のクラスの GIF JSON を validate することを目的とした JSON Schema です
- リテラルは format で判定されます
- format にはプロパティ名がアサインされます
- 動作のためには使用する JSON Schema Validator に対してカスタム Format の登録が必要です

# Test

以下の手順で schema フォルダ配下の JSON Schema がテストできます。

```
$ tar xvzf gif-component-tools-schema-1.0.0.src.tar.gz
$ cd gif-component-tools-schema-1.0.0
$ npm install
$ npm test

> @dev-gif-component-tools/schema@1.0.0 test
> tape test/test-*.js

TAP version 13
# compile
ok 1 Accessibility.schema.json
ok 2 Accessibility.semantic.schema.json
ok 3 Address.schema.json
(中略)

1..162
# tests 162
# pass  162

# ok

$

```

## test/test-compile.js

`shema` 配下の JSON Schema を [ajv](https://www.npmjs.com/package/ajv) でコンパイルできるかどうかをテストします。
`*.semantic.schema.json` の検証に必要なカスタムフォーマットの登録には `lib/mock.js` が使用されます。
本テストで JSON Schema 群が JSON Schema draft07 に適合することが確認できます。

## test-schema.js

`test` 配下には GIF の各クラスごとの正常系テストデータ／異常系テストデータが収録されています。

たとえば `test/Event.pass.json` はイベント型の正常系テストデータ、
`test/Event.fail.json` はイベント型の異常系テストデータです。

個々のクラスに対して、以下のようなテストデータとスキーマの組み合わせで検査を実施し、
意図した通りの検証結果が出力されるかを確認できます。

- {class}.pass.json と {class}.schema.json が valid であること
- {class}.pass.json と {class}.semantic.schema.json が valid であること
- {class}.pass.json と all.schema.json が valid であること
- {class}.pass.json と all.semantic.schema.json が valid であること
- {class}.fail.json と {class}.semantic.schema.json が valid でないこと
- {class}.fail.json と {class}.schema.json が valid でないこと
- {class}.fail.json と all.schema.json が valid でないこと
- {class}.fail.json と all.semantic.schema.json が valid でないこと

(以上)
