# コア語彙解説書 バージョン1.0 (2020-02-28公開)
# 1. 語彙について
## 1.1 用語と語彙
「語彙」は、一般には「語」(言葉、単語)の集合を意味しますが、共通語彙基盤における「語彙」とは、語の背景にある概念の集合です。特に共通語彙基盤では、ファイルやインターネットなどを介して行われるコンピューター間のデータ通信を円滑かつ確実に行うことを目的として、語(言葉、単語)が指す概念の意味や構造、概念と他の概念の関係などを明確にしたものです。共通語彙基盤では、特に混同がない場合は、そのような語で表される概念を「用語」と呼んでいるので、「語彙」は「用語」の集合ということになります。

共通語彙基盤では、類似の用語、重複する用語、分野で意味が異なる同一語といった用語など、コンピューター処理を難しくさせている用語の問題を解決するため、概念的な同一性を保証する形で「用語」を定義しています。

## 1.2 コア語彙
コア語彙は、共通語彙基盤の基礎をなすもので、氏名、住所、組織等、あらゆる社会活動で使用される中核的な用語の集合です。多くのシステム間で情報交換のための基礎となる語彙で、データ交換、オープンデータの二次利用等の効率化に役立つものです。
共通語彙基盤が提供する語彙は、意味や根拠を明確にするとともに、体系化、階層構造化により、正確に物事を表現することで、同じ単語を違う意味で使うことによる誤解や、違う単語を同じ意味で使うことによる意思疎通の不便さを解消することができます。また、広域での情報連携を促進し、流通性の高いアプリケーションを整備することが可能となります。

### (1) コア語彙の記述
コア語彙の用語を書く際には **ic:用語名** のように記述します。用語名に付加している **ic:** は特定の用語がコア語彙で定義されている用語であることを示すときに慣用的に使われる接頭辞です。 IMI Core vocabulary の略表記として **ic:** を使用しています。IMI共通語彙基盤の提供する文書や情報ではこの接頭辞を用いています。 例えば、コア語彙のクラス用語、**場所型** を表現する際には **ic:場所型** と記載します。

## 1.3 IMI語彙の構造
### (1) 語彙の構造
語彙の構造として、2種類の概念があります。一つは「人」「施設」「イベント」と行った事柄(事物や出来事)に関する概念で、これをクラス概念と呼びます。もう一つは、事柄(クラス概念)の性質や事柄と事柄の関係を指し示す概念で、先の「人」であれば、その性質である「性別」や「名前」にあたるもので、これをプロパティ概念と呼ぶことにします。 概念にはクラス概念とプロパティ概念がありますが、共通語彙基盤では概念を「用語」と呼んでいるので、それらをクラス用語とプロパティ用語といい換えることができます。そのため、これ以降、「クラス用語」「プロパティ用語」として説明します。
実際に語彙を作り上げるためには、クラス用語とプロパティ用語およびそれらの関連性を定義する必要があります。それで、クラス用語とプロパティ用語の関係、またそれぞれの用語の表記について以下に説明します。

### (2) クラス用語とプロパティ用語

クラス用語は、何らかの事柄に関する概念を表す用語であり、プロパティ用語は、それらの事柄の性質や事柄と事柄の関係を指し示す概念を表すための用語です。つまり、クラス用語は一つ以上の組合せ可能なプロパティ用語をもち、プロパティ用語は、データ値を直接もつこともあれば、他のクラス用語と関連付けられることもあります。

クラス用語は、その性質・属性を表すプロパティ用語の組合せで定義されます。そして、プロパティ用語は次のいくつかの情報によって定義されます。

#### プロパティ用語の値型
プロパティ用語によって結び付けられるテキストデータの書式や他のクラス用語をプロパティ用語の「値型」と呼びます。
値型が文字列や日付等のテキストデータの書式の場合、プロパティ用語が値を直接もつ形になります。(詳細は「1.6値型(クラス用語除く)の一覧とその記述例」を参照)
値型がクラス用語の場合は、値型として指定されたクラス用語がもつプロパティ用語の値型へと間接的に結び付けられます。つまり、そのような用語を実装(表現)したデータは、いくつかのクラス用語を経て末端のテキストデータにたどり着くような階層構造をもちます。

<img src="images/1-1.png" width=80%>

#### プロパティ用語の回数
プロパティ用語は、クラス用語を何らかの事柄に結び付けるために用いられるものですが、同一のプロパティ用語で同時に別個の事柄と結び付けることもあります。そのような場合は、同一プロパティ用語を複数回使用することになります。このように、一つのクラス用語に対して、プロパティ用語を何回使用できるかを最小出現回数と最大出現回数で定義したものをプロパティ用語の「回数」と呼びます。

例えば、クラス用語「定期スケジュール」に対して、プロパティ用語「開催期日」を2回使用して、"火曜日"、"木曜日"という2つの曜日が結び付けられる場合があります。

## 1.4 継承による新規クラス用語の作成
語彙のクラス用語をベースに、プロパティ用語の追加、回数の変更などを行って新たなクラス用語を定義することをクラス用語の「継承」と呼びます。
共通語彙基盤の核となる「コア語彙」では、プロパティ用語を追加してクラス用語を拡張し派生させていく「継承」の手法を使っています。

<img src="images/1-2.png" width=50%>

## 1.5 コア語彙　ー　継承関係⼀覧
* 1.4でも触れたとおり、コア語彙のクラス用語は継承を重ねることで様々な意味を表現する語彙として成り立っています。  
その第一階層は概念型として定義されており、そこから樹形図上にクラス用語が派生しています。  
以下にコア語彙の継承関係を示します。(非推奨および将来整備予定の用語は除く)

| 第1階層    	| 第2階層       | 第3階層      | 第4階層     	| 第5階層      	| 第6階層     	|
|-------------|---------------|--------------|--------------|---------------|--------------|
| ic:概念型  	|              |             	|             	|             	|           	|
| ic:概念型  	| ic:長さ型     |             	|             	|             	|           	|
| ic:概念型  	| ic:重量型     |             	|             	|             	|           	|
| ic:概念型  	| ic:面積型     |             	|             	|             	|           	|
| ic:概念型  	| ic:容量型     |             	|             	|             	|           	|
| ic:概念型  	| ic:数量型     |             	|             	|             	|           	|
| ic:概念型  	| ic:人数型     |             	|             	|             	|           	|
| ic:概念型  	| ic:金額型     |             	|             	|             	|           	|
| ic:概念型  	| ic:日付型     |             	|             	|             	|           	|
| ic:概念型  	| ic:日時型     |             	|             	|             	|           	|
| ic:概念型  	| ic:施設関連型 |             	|             	|             	|           	|
| ic:概念型  	| ic:組織関連型 |             	|             	|             	|           	|
| ic:概念型  	| ic:構成員型   |              |             	|             	|           	|
| ic:概念型  	| ic:関与型     |             	|             	|             	|           	|
| ic:概念型  	| ic:アクセス型 |             	|             	|             	|           	|
| ic:概念型  	| ic:アクセス区間型 |             	|             	|             	|           	|
| ic:概念型  	| ic:参照型     |             	|             	|             	|           	|
| ic:概念型  	| ic:記述型     |             	|             	|             	|           	|
| ic:概念型  	| ic:状況型     |             	|             	|             	|           	|
| ic:概念型  	| ic:ID型       |             	|             	|             	|           	|
| ic:概念型  	| ic:コード型   |             	|             	|             	|           	|
| ic:概念型  	| ic:コード型   | ic:単位コード型 |             	|            	 |            	|
| ic:概念型  	| ic:期間スケジュール型 |             	|             	|             	|           	|
| ic:概念型  	| ic:期間スケジュール型 | ic:期間型     |             	|            	 |            	|
| ic:概念型  	| ic:期間スケジュール型 | ic:イベントスケジュール型 |             |            	 |            	|
| ic:概念型  	| ic:期間スケジュール型 | ic:定期スケジュール型 |             	|            	 |            	|
| ic:概念型  	| ic:制約型     |             	|             	|             	|           	|
| ic:概念型  	| ic:制約型   	 | ic:範囲制約型 |             	|            	 |            	|
| ic:概念型  	| ic:制約型   	 | ic:期間制約型 |              	|             	|            	|
| ic:概念型  	| ic:制約型   	 | ic:コード制約型 |            	|              	|            	|
| ic:概念型  	| ic:事物型     |             |             	|             	|           	|
| ic:概念型  	| ic:事物型     | ic:名称型    |             	|            	 |            	|
| ic:概念型  	| ic:事物型     | ic:氏名型    |             	|            	 |            	|
| ic:概念型  	| ic:事物型     | ic:住所型    |             	|            	 |            	|
| ic:概念型  	| ic:事物型     | ic:連絡先型  |             	|            	 |            	|
| ic:概念型  	| ic:事物型     | ic:価格型    |             	|            	 |            	|
| ic:概念型  	| ic:事物型     | ic:座標型    |             	|            	 |            	|
| ic:概念型  	| ic:事物型     | ic:活動型    |             	|            	 |            	|
| ic:概念型  	| ic:事物型     | ic:対象型    |             	|            	 |            	|
| ic:概念型  	| ic:事物型     | ic:文書型    |             	|            	 |            	|
| ic:概念型  	| ic:事物型     | ic:イベント型 |             	|            	 |            	|
| ic:概念型  	| ic:事物型     | ic:サービス型 |             	|            	 |            	|
| ic:概念型  	| ic:事物型     | ic:設備型    |             	|            	 |            	|
| ic:概念型  	| ic:事物型     | ic:ID体系型  |             	|            	 |            	|
| ic:概念型  	| ic:事物型     | ic:コードリスト型 |             	|            	 |            	|
| ic:概念型  	| ic:事物型     | ic:実体型    |             	|            	 |            	|
| ic:概念型  	| ic:事物型     | ic:実体型    | ic:人型     	 |             	|            	|
| ic:概念型  	| ic:事物型     | ic:実体型    | ic:組織型   	|             	|           	|
| ic:概念型  	| ic:事物型     | ic:実体型    | ic:組織型   	| ic:業務組織型 	|            	|
| ic:概念型  	| ic:事物型     | ic:実体型    | ic:組織型     | ic:業務組織型 	| ic:法人型   	|
| ic:概念型  	| ic:事物型     | ic:場所型    |             	|             	|             	|
| ic:概念型  	| ic:事物型   	 | ic:場所型    | ic:地物型     |             	|             	|
| ic:概念型  	| ic:事物型     | ic:場所型    | ic:地物型     | ic:土地型     	|             	|
| ic:概念型  	| ic:事物型     | ic:場所型    | ic:地物型     | ic:建物型     	|             	|
| ic:概念型  	| ic:事物型     | ic:場所型    | ic:地物型     | ic:施設型     	|             	|
| ic:概念型  	| ic:事物型     | ic:場所型    | ic:地物型     | ic:施設型     	| ic:駐車場型 	|
| ic:概念型  	| ic:事物型     | ic:製品型    |              |              	|             	|
| ic:概念型  	| ic:事物型     | ic:製品型    | ic:製品個品型 |              	|             	|
| xsd:string 	| ic:電話番号型 	|            	|              	|              	|             	|

## 1.6 値型(クラス⽤語除く)の⼀覧とその記述例
コア語彙のプロパティとして直接データを持つことができるものには、値型としてXML Schema、UN/CEFACTにてデータタイプが定義されています。  
* XML Schema の値型一覧と用例

| データタイプ           　| 説明                   	| 用例                                         	|
| -----------------------	| ---------------------- | --------------------------------------------- |
| xsd:string             	| 文字列                 | IMI, 東京都文京区, IPA                         	|
| xsd:anyURI             	| URI形式の文字列       	| https://imi.go.jp/                           	|
| xsd:nonNegativeInteger 	| 0以上の整数           	 | 0,1,2,…                                     	 |
| xsd:decimal            	| 10進数               	 | -1.23, 0, 123.4                               |
| xsd:integer            	| 整数                 	 | …,-2,-1,0,1,2,…                               |
| xsd:double             	| 倍精度64ビット浮動小数   | +1234.567, -1.2345e67, -.56E-7,<br> INF, -INF, 0 |
| xsd:dateTime           	| 日時"YYYY-MM-DDThh:mm:ss" で指定します<br>YYYY:年<br>MM:月<br>DD:日<br>T:日付と時刻の区切り記号<br>hh:時間<br>mm:分<br>ss:秒 | 2020-01-01T01:01:01, <br>2020-01-01T01:01:01Z(UTC) |
| xsd:date               	| 日付"YYYY-MM-DD" で指定します<br>YYYY:年<br>MM:月<br>DD:日 | 2020-01-01, <br>2020-01-01Z(UTC) |
| xsd:time               	| 時刻"hh:mm:ss.sss" で指定します<br>hh:時間<br>mm:分<br>ss:秒<br>sss:ミリ秒 | 01:01:01.000, <br>01:01:01.000Z(UTC) |
※　正式な情報を取得するには [W3C](https://www.w3.org/TR/xmlschema-2/) のページを参照の事

* UN/CEFACT の値型一覧と用例  

| データタイプ | 説明 | 用例 | 参照先 |
|-------------|------|-----|--------|
| uncefactISO4217: ISO3AlphaCurrencyCodeContentType | 通貨コードを記述するための プロパティ用語 | JPY:日本円,<br>USD:アメリカドル,<br>EUR:ユーロ,<br>GBP:ポンド,<br>CHF:フラン | ISO_ISO3AlphaCurrencyCode_2012-08-31.xsd |
※　正式な情報を取得するには [UNECE/UN/CEFACT XML Schema:2019 XML Schemas version 19A](https://www.unece.org/fileadmin/DAM/uncefact/xml_schemas/D19A.zip)のページを参照の事

## 1.7 構造化項目名記法の基本
構造化項目名記法は、IMI 語彙などの階層構造をもつデータ表現の位置を文字列によって表現するための仕様です。構造化項目名記法を利用することで、階層構造をもつデータを表形式のデータとして表現することができるようになるため、階層構造をもつデータの表計算ソフトウェアによる編集や、表計算ソフトウェアなどで作成されたデータから階層化されたデータへの効率的な変換ができるようになります。(構造化項目名記法は、本ドキュメント「2.チュートリアル」において、語彙を使ってデータを表現する手法として用いています。)

構造化項目名は、クラス用語 > プロパティ用語 > プロパティ用語 > ・・・のように「>」で区切って一つのクラス
用語と任意の数のプロパティ用語を並べたものです。 非常に簡単な例を次に示します。

**施設型>種別**

* 施設型のプロパティ

| 識別子 | 値型 |
| ------ | ---- |
| ic:種別 | xsd:string |

この例では、「施設型」というクラス用語のプロパティである「種別」を使用することを意味しています。
ここで、「種別」プロパティの値型は単純な文字列 (xsd:string) です。この解説書では、このようなデータの構造を表現する場合に、下図のように円、矢印、長方形を用いた図を用います。
ここで、円 はクラス用語を、矢印はプロパティ用語を、長方形は単純な値を表します。上の例を図に表したものが、下図になります。

<img src="images/1-3.png" width=40%>

プロパティの値型がクラス用語である場合、「地理座標」プロパティの値型である「座標型」にもプロパティがあります。

**施設型>地理座標>緯度**

* 施設型のプロパティ

| 識別子 | 値型 |
| ------ | ---- |
| ic:地理座標 | ic:座標型 |

* 座標型のプロパティ

| 識別子 | 値型 |
| ------ | ---- |
| ic:緯度 | xsd:string |

構造化項目名では、「座標型」のプロパティを記述する場合に、上記のように「施設型> 地理座標」 の後に続けて表記します。

<img src="images/1-4.png" width=60%>

### (1) グループ名の利用
構造化項目名記法ではクラスのデータを区別するために、それぞれのクラスに名前を付けることができ、その名前をグループ名と呼びます。
グループ名には、任意の文字列を指定することができ、各用語の後ろに「[」 と「]」に囲んで記述します。
グループ名を使用することで、同じプロパティを複数使う場合に、プロパティの先にあるデータを区別することができます。

**人型>氏名[本名]>姓**  
**人型>氏名[本名]>名**  
**人型>氏名[芸名]>姓**  
**人型>氏名[芸名]>名**  

* 人型のプロパティ

| 識別子 | 値型 |
| ------ | ---- |
|ic:氏名|ic:氏名型|

* 氏名型のプロパティ

| 識別子 | 値型 |
| ------ | ---- |
|ic:姓|xsd:string|
|ic:名|xsd:string|

この例は、下図のような階層構造を表しています。ここで、上側の「氏名」は氏名 [本名] を表しています。

<img src="images/1-5.png" width=60%>

### (2) 主キーの設定
データを作成する場合には、データに含まれる事物を正しく参照できるようにするためにデータ中の各事物に一意のキーを与える必要があります。例えば、施設の一覧であれば各施設を一意に特定するためのキーが必要になります。表形式データの行番号を用いることは推奨されません。20行目に記載された施設は、途中の行が削除されてしまうと19行目になってしまいます。このように、行番号と各施設の対応は変わってしまうからです。各施設に、将来にわたって変わることがない番号や文字列を与えるのが理想的です。そのような番号や文字列を与えることが難しい場合は、施設の名前や電話番号など、できるだけ変化しないものをキーとすることで代用します。構造化項目名記法では、先頭に「\*」を付けることでその項目を主キーとすることを指定することができます。

次の例は、施設の名称の表記を主キーとして設定しています。  

**\*施設型>名称>表記**  
**施設型>名称>カナ表記**  
**施設型>種別**  
**・・・**

### (3) URL変換
項目の内容を値としてデータに含めるのではなく、インターネット上にあるリソースを参照としたい場合があります。例えば、施設の関連施設のデータがすでにインターネット上にある場合、その関連施設の名称、電話番号や住所をデータの中に含めるよりも、その施設のデータを参照した方が効率的です。このように、その項目の内容を URL として扱う必要がある場合があります。構造化項目名記法では、最後を>で終了することで、内容を URL として扱うことを表します。  
次に例を示します。

**施設型**  
**施設型>名称>表記**  
**施設型>関連施設>**  

### (4) 固定値制約
固定値制約は、プロパティに固定の値を設定するために使用されます。
固定値制約では、値を設定したいプロパティ用語、「=」、設定する値(引用符で囲む)の順に記述し、その全体 を「{」「}」で囲みます。例えば、連絡先型の種別プロパティに「担当」や「現地」という値を設定する場合には、次の例のように記述します。

**イベント型>連絡先[担当課]{種別='担当'}>電話番号**  
**イベント型>連絡先[担当課]{種別='担当'}>FAX番号**  
**イベント型>連絡先[当日連絡先]{種別='現地'}>電話番号**  

* イベント型のプロパティ

| 識別子 | 値型 |
| ------ | ---- |
| ic:連絡先 | ic:連絡先型 |
| ic:種別 | xsd:string |

* 連絡先型のプロパティ

| 識別子 | 値型 |
| ------ | ---- |
| ic:電話番号 | ic:電話番号型 |
| ic:FAX番号 | ic:電話番号型 |

<img src="images/1-6.png" width=90%>

### (5) 型制約
共通語彙基盤では、プロパティの値に、値型として指定されている型(クラス用語)だけでなく、その型を継承するすべての型を指定することができます。型制約は、プロパティの値として実際に使用する型を指定するために使用されます。
型制約では、「@」に続けて指定する型のクラス用語を記述し、その全体を「{」「}」で囲みます。例えば、施設型の関与プロパティの値型は、関与型となっており、その先の関与者プロパティの値型は実体型です。実際のデータでは、実体型を継承する人型を使用したい場合には、次の例のように記述します。

**施設型>関与>関与者{@人型}**  
**施設型>関与{役割='管理者'}>関与者{@人型}**  

* 施設型のプロパティ

| 識別子 | 値型 |
| ------ | ---- |
|ic:関与|ic:関与型|

* 関与型のプロパティ

| 識別子 | 値型 |
| ------ | ---- |
| ic:関与者 | ic:実体型  |

* 継承関係

| 第1階層    	| 第2階層      	| 第3階層        | 第4階層       | 第5階層      	| 第6階層      |
| -----------	| -------------- | ------------- | ------------- | ------------	| ------------ |
| ic:概念型  	| ic:事物型     	| ic:実体型      | ic:人型      	|              |             	|
| ic:概念型  	| ic:事物型     	| ic:実体型      | ic:組織型     | ic:業務組織型	| ic:法人型   	|

型制約でプロパティの値型を実体型から人型へ置き換えた例

<img src="images/1-7.png" width=80%>

# 2. チュートリアル
語彙を使ってデータを表現することの目的は、コンピュータ等でデータを処理させる際に値としてのデータだけではなく、そのデータ項目が何を表しているのか(語彙)と値をセットにして受け渡し可能にするデータ(ここではIMIデータと呼びます)を作成することです。

本章では、語彙を使ってデータを表現するための基本的な知識として、データ項目と語彙との関係づけをIMI技術仕様の一つである構造化項目名記法を用いて行っていく方法をチュートリアル形式で解説いたします。
また、実際のデータはコア語彙だけで表現するのは難しい場合がほとんどですが、ここではコア語彙を利用するための解説を中心に行っていきます。

## 2.1 シンプルな名簿を表現する
本節では、もっとも単純な例として以下の名簿データを対象にコア語彙を使った表現を解説します。

* 対象とする名簿データ

| 氏名 | 性別 | 生年月日 |
| ---- | ---- | ------- |
| 情報花子 | 女 | 2020/01/01 |
| 推進太郎 | 男 | 2020/02/02 |

### (1) ルートクラスの選定
語彙を利用してデータを表現する場合、そのデータ(データセット)が主として何を表しているのかを表現するためのクラス用語(単にクラスと呼ぶこともあります)を選定する必要があります。

今回の名簿データであれば、人に関する情報の集まりであることから、コア語彙の中に定義されている人型クラスを選定します。選定したクラスはルートクラスと呼ばれることが多いです。

ルートクラス選定のためにはコア語彙のクラス用語をある程度把握しておく必要がありますが、本書第3章に代表的なクラス用語の説明を記載していますので参照してください。

* 名簿データのルートクラスに人型を選定

### (2) プロパティの選定
データセットを構成するデータ項目が何を表しているのかを表現するために、ルートクラスに定義されているプロパティ用語(単にプロパティと呼ぶこともあります)から適切なものを選定します。

プロパティには値型と呼ばれるデータ形式が定義されています。値型には大きく二つの分類があり、一つは値の記述形式(文字列・数字など)を示すもので、もう一つは他のクラスへの参照を示します。値の記述形式を示す値型の詳細については1.3(2)および1.6を参照してください。

値型が他のクラスへの参照であった場合、プロパティ選定は参照先クラスのプロパティを階層的にたどって値の記述形式が定義されている値型を持つプロパティを選定していきます。

今回の名簿データの場合、以下の様にプロパティ選定を行っていきます。
* 「氏名」は人型クラスの氏名プロパティが意味的に同じと考えられますが、値型が氏名型となっているため氏名型にあるプロパティからさらに適切なものを探します。氏名型にある姓名プロパティは値型が文字列(xsd:string)として定義されているのでこれを選定
* 「性別」は人型クラスの性別プロパティが意味的に同じと考えられ、値型が文字列(xsd:string)として定義されているので、これをそのまま選定
* 「生年月日」は人型クラスの生年月日プロパティが意味的に同じと考えられますが、値型が日付型となっているため日付型にあるプロパティからさらに適切なものを探します。日付型にある表記プロパティは値型が文字列(xsd:string)として定義されているのでこれを選定(このプロパティ選定については2.2(1)も参照)

### (3) データ項目を語彙の表現形式で記述
共通語彙基盤では、クラス用語とプロパティ用語の階層構造を構造化項目名という形式を用いて表します。構造化項目名の書き方はIMI技術仕様の『構造化項目名記法』として提供しています。

構造化項目名の最も基本的な書き方は、「クラス用語名 > プロパティ用語名」の様に階層構造を ">"　記号で連ねて書くことです。構造化項目名記法の詳細については1.7を参照してください。

* 構造化項目名記法を用いた名簿データの例

| データ項目名 | 構造化項目名 | 意味     |
|------------ | ----------- | ------- |
| 氏名 | 人型>氏名>姓名 | 人型クラスの氏名プロパティ(氏名型)にある姓名プロパティ |
| 性別 | 人型>性別 | 人型クラスの性別プロパティ |
| 生年月日 | 人型>生年月日>表記 | 人型クラスの生年月日プロパティ(日付型)にある表記プロパティ |

なお、コア語彙のクラス用語やプロパティ用語を記述する場合、その用語がコア語彙であることを示すための接頭辞として"ic:"を各用語の前に付加するのが正式な記述となりますが、本章では読みやすさを優先し基本的に接頭辞は割愛して記載いたします。上記の例で「性別」に対する構造化項目名の正式な記述は「ic:人型>ic:性別」となります。

### (4) データの生成(変換)
構造化項目名を用いて、各データ項目と語彙との関係づけができていれば、ITエンジニア等がその関係づけを基に自分たちのコンピュータシステムで処理しやすい形式(XML, JSON-LD, Turtleなど)のIMIデータを生成(変換)します。
データ変換はある程度機械的に処理可能なためツール等を用いて実施することが想定されており、IMIではデータ変換を支援するためのツールとして「IMIツール」や「IMI共通語彙基盤ライブラリ」などを提供しています。

なおデータ変換の詳細を理解するには、IMIの技術仕様全般やプログラミング手法等に関する広範な知識が必要となるため、本書では解説しておりません。

以下に、今回の名簿データをコンピュータ処理用に変換したIMIデータを例示します。
* XML形式の場合
```
<root xmlns:ic='http://imi.go.jp/ns/core/2' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'>
  <ic:人 xsi:type='ic:人型'>
    <ic:氏名 xsi:type='ic:氏名型'>
      <ic:姓名>情報花子</ic:姓名>
    </ic:氏名>
    <ic:性別>女</ic:性別>
    <ic:生年月日 xsi:type='ic:日付型'>
      <ic:表記>2020/01/01</ic:表記>
    </ic:生年月日>
  </ic:人>
  <ic:人 xsi:type='ic:人型'>
    <ic:氏名 xsi:type='ic:氏名型'>
      <ic:姓名>推進太郎</ic:姓名>
    </ic:氏名>
    <ic:性別>男</ic:性別>
    <ic:生年月日 xsi:type='ic:日付型'>
      <ic:表記>2020/02/02</ic:表記>
    </ic:生年月日>
  </ic:人>
</root>
```
* JSON-LD形式の場合
```
{
	"@graph": [
		{
			"@type": "人型",
			"氏名": {
				"姓名": "情報花子",
				"@type": "氏名型"
			},
			"性別": "女",
			"生年月日": {
				"表記": "2020/01/01",
				"@type": "日付型"
			}
		},
		{
			"@type": "人型",
			"氏名": {
				"姓名": "推進太郎",
				"@type": "氏名型"
			},
			"性別": "男",
			"生年月日": {
				"表記": "2020/02/02",
				"@type": "日付型"
			}
		}
	],
	"@context": "https://imi.go.jp/ns/core/context.jsonld"
}
```

## 2.2 データを詳細化し住所録を表現する
本節では、2.1で作成した名簿データを参考に、データの汎用性を高めるためのデータ加工や項目追加について住所録データを例に説明するとともに、それらをどのように構造化項目名で表現するかを解説します。

* 対象とする住所録データ

| 氏名 | 性別 | 生年月日 | 郵便番号 | 住所 | 電話番号 |
| --- | ---- | -------- | ------- | ---- | ------- |
| 情報花子(ジョウホウハナコ) | 女 | 20200101 | 1130021 | 東京都文京区・・・ | 03XXXX1234 |
| 推進太郎(スイシンタロウ)   | 男 | 20200202 | 1000001 | 東京都千代田区・・・ | 03XXXX5678 |

### (1) データの細分化や値の記述形式の変更
表形式のデータからIMIデータを作る時には、元になる表を変換しやすく設計しておくことが望ましいです。

#### データの細分化
データ項目に対するプロパティの選定に際して複数のプロパティの値になるような値を持つ項目はあらかじめ、分けておいたほうが良いでしょう。

例えば、ある施設の利用可能時間のデータとして以下のようなデータがある場合、データ項目を分割しておくと変換が容易です。
| データ項目名 | 値 |
| ---------- | --- |
| 利用可能時間 | 10:00-17:00 |
| **↓ 項目を分割しておく ↓** | **↓** |
| 利用可能時間(開館)| 10:00 |
| 利用可能時間(閉館)| 17:00 |

また、違うタイプの値が入る可能性のある項目もそれぞれのタイプごとの項目に分けておくと良いでしょう。
例えば、上の例において閉館時間に備考のような記述が含まれているデータがあるような場合は、その記述部分を別項目にしておくことが望まれます。
| データ項目名 | 値 |
| ---------- | --- |
| 利用可能時間(開館)| 10:00 |
| 利用可能時間(閉館)| 17:00 (創立記念日は20:00まで) |
| **↓ 項目を分割しておく ↓** | **↓** |
| 利用可能時間(開館)| 10:00 |
| 利用可能時間(閉館)| 17:00 |
| 利用可能時間に関する備考 | 創立記念日は20:00まで |

#### 値の記述形式の変更
クラス用語の中には、対象としているデータの標準的な表現形式がプロパティの値型として設定されているものがあります。そういった項目を利用する場合は、プロパティ選定時にそのプロパティ用語を選択し、そこで指定されている表現形式にデータを合わせておいたほうがデータの汎用性が高まります。

例えば、日付を表すための日付型にはいくつかのプロパティがありますが、値型にxsd:stringを持ちどのような文字列でも入力可能な表記プロパティを使うよりも、値型にxsd:dateをもつ標準型日付プロパティを用いる方が望ましいです。
| データ項目名 | 選択するプロパティ | 値 | 備考 |
| ----------- | ---------------- | -- | ---- |
| 生年月日 | 人型>生年月日>表記 | 2020/01/01<br>2020年1月1日<br>20200101 | どんな文字列でも入力できるが、コンピュータには使いづらい|
| | **標準的な表現形式のプロパティを選定 ↓** | **データ形式を変更 ↓** | |
| 生年月日 | 人型>生年月日>標準型日付 | 2020-01-01 | コンピュータ処理に適した形式 |

#### 住所録データの場合
今回対象としている住所録データの場合、以下のように氏名の項目を漢字の氏名とカナの氏名に細分化し、生年月日のデータをxsd:dateの形式に変更することで日付型の標準型日付プロパティを利用可能にしておくことが望ましいです。
* 変更後の住所録データ

| 氏名 | 氏名カナ | 性別 | 生年月日 | 郵便番号 | 住所 | 電話番号 |
|---- | -------- | ---- | ------- | ------- | ---- | ------- |
| 情報花子 | **ジョウホウハナコ** | 女 | **2020-01-01** | 1130021 | 東京都文京区・・・ | 03XXXX1234 |
| 推進太郎 | **スイシンタロウ** | 男 | **2020-02-02** | 1000001 | 東京都千代田区・・・ | 03XXXX5678 |

### (2) キー項目の追加
表形式のデータをコンピュータで処理する場合、各行を一意で識別するためのキー項目があらかじめ設計されていることが望ましいです。

ルートクラスとなるようなコア語彙のクラス用語の大半は、キー項目に相当するIDプロパティを持っています。このプロパティを設定するための項目をあらかじめ表データに組み込んでおきます。 キー項目に設定する値は、少なくともそのデータセットの中で一意になるように設定します。(IDについては2.3(3)も参照)

今回対象としている住所録データの場合、以下のようにキー項目として「項番」を追加しておきます。
* キー項目を追加した住所録データ

| 項番 | 氏名 | 氏名カナ | 性別 | 生年月日 | 郵便番号 | 住所 | 電話番号 |
| --- | ---- | -------- | --- | -------- | ------- | ---- | ------- |
| **001** | 情報花子 | ジョウホウハナコ | 女 | 2020-01-01 | 1130021 | 東京都文京区・・・ | 03XXXX1234 |
| **002** | 推進太郎 | スイシンタロウ | 男 | 2020-02-02 | 1000001 | 東京都千代田区・・・ | 03XXXX5678 |


### (3) 語彙との関連付け
データ項目に対してプロパティ用語を選定する際に、プロパティの階層構造をたどっていくと経路上に同じプロパティ用語が複数出てくることが多くあります。このような場合は、その項目の表しているものに最も近い経路のプロパティを選択します。

今回の住所録を考えた場合、住所の項目は「人型 > 住所」にあるほかに「人型 > 連絡先 > 住所」も存在します。どちらを選択するかはもともとのデータが何を意図しているのかで決める必要があります。「住所」に入力されているデータは対象者に所属する住所なのか？、対象者への連絡先に所属する住所なのか？という判断を行います。今回のデータは人の住所録なので対象者に所属する住所として考えるべきでしょう。

一方、コア語彙の利用になれるまでは、該当しそうなプロパティ用語がなかなか出てこない場合がありますが、一般的なデータ項目であれば該当しそうなクラス用語やプロパティ用語から上位に階層をたどってルートクラスまでの経路を選択することができます。

今回の住所録の場合、電話番号の選択がやや難しいのですが、電話番号型というクラス用語がコア語彙にはありますので、そこから上位にたどっていくことで選択できます。まず電話番号型は連絡先型の電話番号プロパティの値型として参照されていることを確認します。次に連絡先型を値型に持つ人型のプロパティを捜します。そうすることで、人型の連絡先プロパティにたどり着くことができます。

* 今回の住所録データの構造化項目名

| データ項目名 | 構造化項目名 | 備考 |
| ----------- | ----------- | ---- |
| 項番 | 人型>ID>識別値 |　|
| 氏名 | 人型>氏名>姓名 | 今回は「氏名」と「氏名カナ」に分割しましたが、「性」「名」等、さらに細分化することでより汎用性の高いデータとなります。 |
| 氏名カナ | 人型>氏名>姓名カナ表記 |  |
| 性別 | 人型>性別 |  |
| 生年月日 | 人型>生年月日>標準型日付 |  |
| 郵便番号 | 人型>住所>郵便番号 |  |
| 住所 | 人型>住所>表記 | 住所型のプロパティには様々なものがあります。用途に応じて使い分けすることで汎用性が高まります。 |
| 電話番号 | 人型>連絡先>電話番号 | コア語彙では電話番号は連絡先型の中にしか出現しません。 |

## 2.3 社員名簿を表現する
本節では、2.2の住所録を参考に、より実践的なデータ項目に対する語彙表現を解説します。

* 対象とする社員名簿データ

| 社員番号 | 氏名 | 住所 | 自宅電話番号 | 職場電話番号 | 所属組織 |
| ------- | ---- | ---- | ------------| ----------- | ------- |
| 10012 | 情報花子 | 東京都文京区・・・ | 03XXXX1234 | 03XXXX4321 | 産業プラットフォーム部 |
| 10023 | 推進太郎 | 東京都千代田区・・・ | 03XXXX5678 | 03XXXX8765 | データ活用推進グループ |

### (1) データの役割を明らかにする
語彙の階層構造を示しただけでは、そのデータ項目が何を表しているのかが不明瞭になることがよくあります。このような場合は語彙表現においてその項目の表していることを補完して記述しておくことが望まれます。

今回の社員名簿データには、「自宅電話番号」「職場電話番号」と電話番号を表す項目が二つあります。これを2.2の住所録で検討した形で記述すると、どちらも「人型>連絡先>電話番号」となってしまい、その違いがわかりません。これら電話番号の違いは「その電話番号はどこにつながるのか」、コア語彙的な表現で言い換えると、「どのような種別の連絡先に属しているのか？」という違いになると考えられます。この「どのような種別の連絡先に属しているのか？」という情報を語彙表現で補完することで違いを明確化します。

今回の自宅電話番号を表すための構造化項目名は以下のような形式をとります。

* 人型>連絡先{種別='自宅'}>電話番号

これは、「人型クラスの連絡先プロパティ(連絡先型)にある種別プロパティに"自宅"を設定した状態の連絡先の電話番号プロパティ」を意味します。

このように、階層構造上のクラス用語が持つ任意のプロパティに固定値を設定することを固定値制約と呼びます。記法の詳細については1.7(4)を参照してください。今回使用した種別プロパティはコア語彙のすべてのクラス用語に設定されていますので、固定値制約を記述する際に最もよく利用されるプロパティとなっています。

職場電話番号も同様に以下のように表現します。

* 人型>連絡先{種別='職場'}>電話番号

#### 同一階層構造のデータが複数ある場合の留意点
今回の電話番号のように語彙の階層構造が同じになるようなデータが複数ある場合、データ変換等の処理を確実に行うための情報として、固定値制約とは別にそれぞれのデータが異なるものであることを示しておく必要があります。

先の電話番号の場合、語彙の階層構造は何れも「人型>連絡先>電話番号」と同じため、これをそのまま機械処理すると連絡先という一つの器に対して意味の異なる二つのデータ(電話番号)を設定しようとすることになり、コンピューター等での処理が難しくなります。このような場合は、器の異なる連絡先を表現するために連絡先にグループ名を付与することで区別します。今回は自宅用の連絡先の器に"1"、職場用の連絡先の器に"2"としてクループ名を付与することにします。この場合の構造化項目名は以下のような形式をとります。

* グループ名を使用した二つの電話番号

| データ項目名 | 構造化項目名 | 意味 |
| ----------- | ----------- | ---- |
| 自宅電話番号 | 人型>連絡先[1]{種別='自宅'}>電話番号 | 人型の連絡先プロパティ(グループ1)にある種別プロパティに"自宅"を設定した状態の連絡先の電話番号プロパティ |
| 職場電話番号 | 人型>連絡先[2]{種別='職場'}>電話番号 | 人型の連絡先プロパティ(グループ2)にある種別プロパティに"職場"を設定した状態の連絡先の電話番号プロパティ |

例では、グループ名に数字を割り振っていますが、グループ名には任意の文字列を指定してかまいませんので以下の様に記述することも可能です。グループ名の記法の詳細については1.7(1)を参照してください。

* 人型>連絡先[自宅]{種別='自宅'}>電話番号
* 人型>連絡先[職場電話番号]{種別='職場'}>電話番号

このグループ名の付与に関する詳細を理解するには、データ変換と同様の知識が必要となります。このため、実際にデータ処理システムを構築する段階でITエンジニア等と相談して決めていただいて構いません。

### (2) プロパティの値型を置き換えて(指定して)利用する
プロパティを選定する際に、意味的に該当しそうなプロパティがあるのに、階層をたどってもそれらしいプロパティが出てこない場合があります。このような場合は、そのプロパティ用語の値型を置き換えて利用することが想定されています。

今回のデータ項目に所属組織がありますが、これのプロパティを選定するために人型のプロパティを確認すると、関与プロパティの説明に「実体に関連する組織や人(関連性の記述を含む)を記述するためのプロパティ用語」とあるため、これが該当しそうです。このプロパティ(関与型)の階層構造をたどると次に関与者プロパティ(実体型)が「関連する組織や人を記述するためのプロパティ用語」と説明されているため、さらに階層構造をたどります。しかしながら実体型のプロパティには組織名だと判別できるような記述を行うプロパティはありません。(ここで関与をさらにたどると無限にループしてしまいます)

語彙の利用ルールの一つに、「プロパティの値には、値型として指定されている型だけでなく、その型を継承するすべての型を指定することがきる」というルールがあり、関与型の関与者プロパティはこのルールを前提に設計されています。

具体的には、関与者プロパティの値型として実体型が指定されているため、この実体型を継承するクラスに値型を置き換えて(指定して)利用します。実体型を継承しているクラス用語は人型と組織型の二つですが、今回の場合は組織名を表すプロパティが必要なことから組織型に値型を置き換えます。

【実体型に関係するコア語彙の構造】
![実体型に関係するコア語彙の構造と値型の指定](./images/2-1.png)

【関与者プロパティの値型の置き換え】
![関与者プロパティの値型の考え方](./images/2-2.png)

組織型のプロパティには表記や名称がありますが今回は簡易化のため表記プロパティを利用することとします。
これを、構造化項目名で表現すると以下のような記述となります。(関与プロパティが何を表しているのかコア語彙表現だけではわからないため、固定値制約を用いて関与の種別プロパティに"所属組織"を設定しています。)

* 人型>関与{種別='所属組織'}>関与者{@組織型}>表記

このように、目的のプロパティの値型をその値型を継承している値型へ置き換える事を型制約と呼びます。記法の詳細は1.7(5)を参照してください。
今回は関与者プロパティの型制約として{@組織型}を記述していますので、関与者プロパティの値型を組織型に置き換え、その先にある表記プロパティを利用可能にしています。

なお、型制約は元の値型を継承していれば、どのクラスでも指定可能なルールではありますが、元の値型と指定する値型の階層が乖離すると意味が分かりにくくなりますので、直接継承しているクラスのみを指定することが望ましいです。また、コア語彙では以下のクラスはこの型制約の利用を前提として検討されています。

| 型制約の利用を想定しているクラス | 値型として指定するクラス |
| ----------------------------- | ---------------------- |
| 実体型 | 人型、組織型  |
| 期間スケジュール型 | 期間型、イベントスケジュール型、定期スケジュール型、詳細スケジュール型、詳細スケジュール規則型 |

### (3) データ項目をより詳細に表現する
コア語彙には多種多様なクラス用語とプロパティ用語が定義されています。コア語彙の利用に慣れてくると、データ項目の表現方法に様々な方法があることに気が付きます。

2.2の住所録の例では、キー項目として単純な項番をデータに追加しました。ここで使用した構造化項目名を以下に示します。
* 人型>ID>識別値

今回の社員名簿では、項番に代わり社員番号が設定されています。したがって、先の電話番号と同様にIDの種別が社員番号であることを補完した方が親切です。補完した構造化項目名を以下に示します。
* 人型>ID{種別='社員番号'}>識別値

ここで、クラス用語「ID型」について少し詳しく見てみましょう。
ID型は「IDを表現するためのクラス用語」として定義されています。コア語彙ではIDは何らかの情報(=「種別」)を一意に識別するために用いられる任意の文字列(=「識別値」)として扱われますが、ID型のプロパティには、「種別」「識別値」以外に「体系(ID体系型)」というプロパティがあることに気づきます。 IDを割り当てる項目は、データをコンピュータ等で処理する際のキー項目となることが多く、データ品質を担保するためにこのキー項目がどのような出自を持つかが重要視される場合は、体系プロパティを用いてID体系情報を記述できるようになっています。ID体系型の特徴的なプロパティには「名称」「発行者」「バージョン」などがありますが、階層構造の先にあるプロパティへの固定値制約は構造化項目名では記述できないため、別途これらプロパティに相当するデータ項目の追加等を検討する必要があります。

データ項目と語彙との関連付けについては、データ設計者によって様々なとらえ方ができるため、これが正解という方法はありません。どのような定義も間違いではなくデータの利用シーンに即した形で検討いただいて問題ありません。先のIDであれば、一番目の簡易な表現は利用者や利用シーンが限定されている非常にクローズドなシステムで利用し、二番目は社内システム全体で社員番号を共通的に表現するために利用します。ID体系情報を項目として追加するような表現は企業統合などのシステム連携で各社の社員番号体系を識別するような場合に利用することが期待されます。

## 2.4 コア語彙の人型では表現が難しい項目の追加
本章冒頭でも記載した通り、実際のデータはコア語彙だけで表現するのは難しい場合がほとんどです。
本節では、2.3で扱った社員名簿をもとに、今後語彙を使ってデータを表現していく上でのヒントとなるような例を解説していきます。

### (1) 記述プロパティを使ったとりあえずの対応
2.3で使用した社員名簿の項目に入社年月日を追加したいとします。人型には入社年月日を表現するようなプロパティはありませんが、種別付きの説明文を記述するための記述プロパティによってある程度の項目であれば対応可能です。構造化項目名で表記すると以下のようになります。
* 人型>記述{種別='入社年月日'}>説明

### (2) コア語彙を拡張して新たなクラス用語を作成する
(1)の方法である程度の対応は可能ですが、本質的な観点から以下の疑問が生じます。
* 入社年月日を表現するプロパティとしては日付型を用いるべきではないのか？
* 入社年月日以外に同様の項目を追加したくなった場合、記述プロパティが異なる意味で無作為に追加されるのではないか？

このような場合は、社員名簿用のクラス用語を新たに作成することが望ましいと考えられます。新たなクラス用語は、コア語彙を継承して作成します。今回の場合は、人型クラスを継承して社員名簿型クラスを作成し、そこへ日付型の値型を持つ入社年月日プロパティを追加することで対応可能です。

【社員名簿型クラスの構造】
![社員名簿型クラスの構造](./images/2-3.png)

コア語彙を継承して新たなクラス用語やプロパティ用語を作成することを、IMIでは応用語彙を作成するといいます。応用語彙の作成はIMI技術仕様にある語彙記法を用いて行いますが、実際の定義や利用法についてはデータ処理システムを構築する段階でITエンジニア等と相談して決めていただいくことをお勧めします。

参考として、前述した社員名簿型クラスを語彙記法を用いて記述した際の例を以下に記載します。
```
#prefix ic: 'http://imi.go.jp/ns/core/2#'
#prefix ex: 'http://example.org/'
vocabulary 'http://example.org/' ;

#name '入社年月日'
property ex:入社年月日 {@ic:日付型} ;

#name '社員名簿型'
class ex:社員名簿型 {@ic:人型} ;

#name '入社年月日'
set ex:社員名簿型 > ex:入社年月日 ;
```

# 3. クラス用語解説
本章では、コア語彙の個々のクラス用語についてそのクラス用語が記述対象としているデータの概要や、クラス用語を使ってデータを記述する際のヒントについて解説しています。

解説はクラス用語の利用方法を4種のカテゴリーに分類して行っています(下表参照)。このカテゴリーは目安として定めたもので、実際の利用方法を制限するものではありません。

|章節| カテゴリー | 対象クラス用語 |
|:-- |:--------- |:--------------|
|3.1|主にデータセットのルートクラスとして用いるクラス用語|[文書型](#文書型)、[イベント型](#イベント型)、[サービス型](#サービス型)、 [設備型](#設備型)、[人型](#人型)、[組織型](#組織型)、[業務組織型](#業務組織型)、[法人型](#法人型)、[場所型](#場所型)、[地物型](#地物型)、 [土地型](#土地型)、[建物型](#建物型)、[施設型](#施設型)、[駐車場型](#駐車場型)、[製品型](#製品型)、[製品個品型](#製品個品型) |
|3.2|主にデータ項目の値型として部品的に用いるクラス用語|(解説あり) <br> [人数型](#人数型)、[日付型](#日付型)、[日時型](#日時型)、[組織関連型](#組織関連型)、[構成員型](#構成員型)、[関与型](#関与型)、[アクセス型](#アクセス型)、[アクセス区間型](#アクセス区間型)、[参照型](#参照型)、[記述型](#記述型)、[状況型](#状況型)、[期間型](#期間型)、[イベントスケジュール型](#イベントスケジュール型)、[定期スケジュール型](#定期スケジュール型)、[範囲制約型](#範囲制約型)、[期間制約型](#期間制約型)、[コード制約型](#コード制約型)、[住所型](#住所型)、[連絡先型](#連絡先型)、[活動型](#活動型)、[対象型](#対象型)、[電話番号型](#電話番号型) <br> (解説なし) <br> [長さ型](#長さ型)、[重量型](#重量型)、[面積型](#面積型)、[容量型](#容量型)、[数量型](#数量型)、[金額型](#金額型)、[施設関連型](#施設関連型)、[名称型](#名称型)、[氏名型](#氏名型)、[価格型](#価格型)、[座標型](#座標型)|
|3.3|IDやコードを表現するために用いるクラス用語|[ID型](#id型)、[コード型](#コード型)、[単位コード型](#単位コード型)、[ID体系型](#id体系型)、[コードリスト型](#コードリスト型)|
|3.4|語彙定義の基礎として用いる抽象的なクラス用語|[概念型](#概念型)、[期間スケジュール型](#期間スケジュール型)、[制約型](#制約型)、[事物型](#事物型)、[実体型](#実体型)|

3.2で「解説なし」としたクラス用語については、基本的に3.1の解説の中で使い方等を示しています。

## 3.1 主にデータセットのルートクラスとして用いるクラス用語
### [文書型](#文書型)
#### 概要
文書の情報を記述するための型です。文書がインターネット上にあるかどうかに関係なく記述することができます。事物型およびそれを継承する型に対するメタデータを記述するときにも使います。

この型の上位は[事物型](#事物型)です。その上位は[概念型](#概念型)です。この型では、事物型、概念型で用意されたプロパティも使われます。詳しくは[事物型](#事物型)、[概念型](#概念型)を参照してください。

#### 利用にあたってのヒント
- 表題の記述
  - 文書の表題は、表題プロパティ(xsd:string)に記述します。

- 作成者の記述
  - 文書を作成した人や組織について書くときは、作成者プロパティ([実体型](#実体型))を使います。
  - 作成者プロパティの値型は実体型ですが、実際にはその継承で作られている[人型](#人型)や[組織型](#組織型)を型制約として指定して使います。
  - 作成者が個人の場合は、作成者プロパティの値型に人型を型制約として指定し、人型の各プロパティを使って所有者の情報を記述します。詳しくは[人型](#人型)を参照ください。
  - 作成者が法人などの組織の場合は、作成者プロパティの値型に組織型を型制約として指定し、組織型の各プロパティを使って所有者の情報を記述します。詳しくは[組織型](#組織型)を参照ください。

- 発行者の記述
  - 文書を発行した人や組織について書くときは、発行者プロパティ([実体型](#実体型))を使います。
  - 発行者プロパティの値型は実体型ですが、作成者プロパティと同じく、実際にはその継承で作られている[人型](#人型)や[組織型](#組織型)を型制約として指定して使います。
    - 例えば、発行者に会社の情報を書きたい場合は、発行者プロパティの値型に組織型を型制約として指定し、組織型の各プロパティを使って会社の情報を記述します。
    - 詳しくは[組織型](#組織型)を参照ください。

- 発行日などの記述
  - 文書に対する様々な日付を書くときは、日付プロパティ([日付型](#日付型))を使って記述します。
    - 例えば"発行日"を書きたい場合は、日付プロパティの先の標準型日付プロパティ(xsd:date)に日付を記述し、種別プロパティ(xsd:string)に"発行日"と記述します。

- ライセンス(権利)の記述
  - 文書のライセンス(権利)を書くときは、権利管理プロパティ([文書型](#文書型))を使います。権利管理プロパティもまた文書型になっています。
  - 文書型でライセンス(権利)について書くときは、表記プロパティ(xsd:string)に権利の名称を記述し、参照プロパティ([参照型](#参照型))を使って典拠となる外部の情報を記述します。

- キーワード(分類)の記述
  - 検索等の利便性を考慮したキーワード(文書の分類)を書くときは、キーワードプロパティ(xsd:string)に記述します。複数のキーワードを指定する場合は" "(空白文字)で区切ります。

- インターネット上の文書へのリンク(URL)の記述
  - 文書がインターネット上に存在する場合には、参照プロパティ([参照型](#参照型))の先の参照先プロパティ(xsd:anyURI)に文書へのリンク(URL)を記述します。

#### 例
|項目名	|構造化項目名	|値|
|:----|:----|:----|-|
|表題     |文書型>表題     | コア語彙解説書  |
|著者    |文書型>作成者{@人型}>氏名>姓名 | 山田　花子 |
|キーワード  |文書型>キーワード  | 共通語彙基盤 解説  |
|発行    |文書型>発行者{@組織型}>名称>表記    | 〇〇出版社   |
|発行日(年) |文書型>日付{種別='発行日'}>年     | 2020   |
|発行日(月) |文書型>日付{種別='発行日'}>月     | 9 |
|発行日(日) |文書型>日付{種別='発行日'}>日     | 1 |
|言語     |文書型>言語>識別値     | ja |

### [イベント型](#イベント型)
#### 概要
お祭りや催しもの、あるいは道路工事情報といった、イベント情報を記述するための型です。典型的なイベントとは、主催者がいて、ある目的を持って日時と場所を決めて行われる出来事です。イベントには1回しか行われない一過性のイベントもあれば、週1回等の周期的に行われるイベント、不定期に繰り返し行われるイベントなどが含まれます。

類似する型として[状況型](#状況型)と[活動型](#活動型)があります。状況型は組織などに付随するもので、時間的に変化する組織の状態を記述するのに使います。活動型における活動とは、組織や人が主体的に行う出来事で、組織や人に関連づけて記述されます。

この型の上位は[事物型](#事物型)です。その上位は[概念型](#概念型)です。この型では、事物型、概念型で用意されたプロパティも使われます。詳しくは[事物型](#事物型)、[概念型](#概念型)を参照してください。

#### 利用にあたってのヒント
- イベントの名称の記述
  - イベントの名称は名称プロパティ([名称型](#名称型))の先の表記プロパティ(xsd:string)を使って記述します。詳しくは[名称型](#名称型)を参照ください。

- イベントの概要の記述
  - イベントの概要を書くときは、要約プロパティ(xsd:string)、説明プロパティ(xsd:string)のどちらか、あるいは両方に記述します。
  - 要約プロパティは一覧表示する場合などに使用する短い概要を記述するときに使い、説明プロパティはイベントの詳細な説明を記述するときに使います。

- 料金の記述
  - イベント参加費等の料金を書くときは、料金プロパティ([価格型](#価格型))を使います。
  - 価格型で料金を書く場合は、料金の対象とその金額についてそれぞれ表記プロパティ(xsd:string)と金額プロパティ([金額型](#金額型))を使って記述します。
    - 金額型で金額を書く場合は、金額の値と通貨の種類をそれぞれ数値プロパティ(xsd:decimal)と通貨プロパティ(xsd:string)を使って記述します。
    - 例えば、大人500円という場合、料金プロパティの先の表記プロパティ(xsd:string)に"大人"と記述し、金額プロパティの先の数値プロパティ(xsd:decimal)に"500"、通貨プロパティ(xsd:string)に"円"と記述します。
  - 年齢などによって料金に種別があるときは、料金プロパティを複数回使って記述します。
    - 例えば、大人、子供の区別があるときは、料金プロパティの先の種別プロパティ(xsd:string)に"大人"あるいは"子供"と記述することで区別します。

- 連絡先や問い合わせ先の記述
  - イベントに関する連絡先や問い合わせ先を書くときは、連絡先プロパティ([連絡先型](#連絡先型))を使います。
    - 例えば、連絡先の名称、電話番号、Eメールアドレスを書く場合、それぞれ、連絡先プロパティの先の表記プロパティ(xsd:string)、電話番号プロパティ([電話番号型](#電話番号型))、Eメールアドレスプロパティ(xsd:string)に記述します。
  - 申込書の送付先など電話以外の連絡先も連絡先プロパティを使って記述します。
  - 当日連絡先や申込書の送付先など複数の連絡先がある場合は、連絡先プロパティを複数回使って記述します。

- 開催場所の記述
  - 開催場所を書くときは、開催場所プロパティ([地物型](#地物型))を使います。
  - 開催場所プロパティの値型は地物型ですが、実際にはその継承で作られている[建物型](#建物型)や[施設型](#施設型)を型制約として指定して使います。
    - 例えば、開催場所(施設)の住所を書くときには、開催場所プロパティの値型に施設型を型制約として指定し、施設型の表記プロパティ(xsd:string)や住所プロパティ([住所型](#住所型))を使って記述します。詳しくは[施設型](#施設型)を参照ください。  

- ホームページの記述
  - インターネットにあるイベントページなどを書くときは、参照プロパティ([参照型](#参照型))の先の参照先プロパティ(xsd:anyURI)に具体的なURLを記述します。詳しくは[参照型](#参照型)を参照ください。

- 対象年齢などの記述
  - 対象年齢などを書くときは、利用対象プロパティ([対象型](#対象型))を使って記述します。詳しくは[対象型](#対象型)を参照ください。

- イベントのカテゴリーの記述
  - イベントのカテゴリーを書くときは、キーワードプロパティ(xsd:string)に記述します。複数のキーワードを指定する場合は" "(空白文字)で区切ります。
  - 主となるカテゴリーは必要に応じて種別プロパティ(xsd:string)にも記述します。

- 開催日時、開催期間の記述
  - イベントが実施される日時あるいは期間は期間プロパティ([期間スケジュール型](#期間スケジュール型))に記述します。
  - 期間プロパティの値型は期間スケジュール型ですが、実際にはその継承で作られている[期間型](#期間型)や[イベントスケジュール型](#イベントスケジュール型)あるいは[定期スケジュール型](#定期スケジュール型)を型制約として指定して記述します。  
    - 例えば、ある日からある日まで開催というスケジュールである場合、期間プロパティの値型に期間型を型制約として指定し、期間型のプロパティである開始日時プロパティ([日時型](#日時型))および終了日時プロパティ([日時型](#日時型))の先の標準型日時プロパティ(xsd:dateTime)を使って記述します。詳しくは期間型を参照してください。
    - 同様に定期的に開催されるイベントの開催日時や開催期間は、期間プロパティの値型に定期スケジュール型を型制約として指定して記述します。詳しくは、定期スケジュール型を参照してください。

## 例
|項目名	|構造化項目名	|値|
|:----|:----|:----|-|
|名称    |イベント型>名称>表記    | 〇〇フェスティバル   |
|概要  |イベント型>説明  | 〇〇のフェスティバルです。   |
|開催場所  |イベント型>開催場所{@施設型}>表記  | 〇〇公園 |
|住所  |イベント型>開催場所{@施設型}>住所>表記  | 東京都〇〇区△△ 0-0-0  |
|連絡先   |イベント型>連絡先[連絡先]>電話番号   | 000-1111-3333   |
|当日連絡先    |イベント型>連絡先[当日連絡先]>電話番号    | 000-1111-2222   |
|対象年齢(上)|イベント型>利用対象>制約{@範囲制約型}{制約対象='人型>年齢>数値'}>上限値{単位表記='歳'}>数値 | 12 |
|対象年齢(下)|イベント型>利用対象>制約{@範囲制約型}{制約対象='人型>年齢>数値'}>下限値{単位表記='歳'}>数値 | 0  |
|料金   |イベント型>料金>金額{通貨='円'}>数値    | 1000   |
|カテゴリー    |イベント型>キーワード  | グルメ フェスティバル |
|開始日  |イベント型>期間{@期間型}>開始日時>標準型日時 | 2020-10-10T00:00:00 |
|終了日  |イベント型>期間{@期間型}>終了日時>標準型日時 | 2020-10-11T00:00:00 |

### [サービス型](#サービス型)
#### 概要
行政サービスなど、組織等が他の組織または人に提供するサービスを記述するための型です。提供するサービスが有形・無形であるかどうかは問わず使用することができます。

この型の上位は[事物型](#事物型)です。その上位は[概念型](#概念型)です。この型では、事物型、概念型で用意されたプロパティも使われます。詳しくは[事物型](#事物型)、[概念型](#概念型)を参照してください。

#### 利用にあたってのヒント
- 種類に関する記述
  - サービスの種類(例えば、健康支援やごみ収集など)を書くときは、種別プロパティ(xsd:string)に記述します。

- 名称の記述
  - 簡単に文字列としてサービスの名称を書きたいときは、表記プロパティ(xsd:string)に記述します。
  - 名称にカナ表記やローマ字表記もある場合は、名称プロパティ([名称型](#名称型))を使います。
  - 名称型でカナ表記やローマ字表記を書くときは、カナ表記プロパティ(xsd:string)やローマ字表記プロパティ(xsd:string)に記述します。詳しくは[名称型](#名称型)を参照ください。

- サービスの対象者に関する記述
  - サービスの対象者について書くときは、対象者の条件を利用対象プロパティ([対象型](#対象型))を使って記述します。詳しくは[対象型](#対象型)を参照ください。

- サービスを提供する人または組織に関する記述
  - サービスを提供する人または組織について書くときは、提供者プロパティ([実体型](#実体型))を使います。
  - 提供者プロパティの値型は実体型ですが、実際にはその継承で作られている[人型](#人型)や[組織型](#組織型)を型制約として指定して使います。
  - サービス提供者が個人の場合は、提供者プロパティの値型に人型を型制約として指定し、人型の各プロパティを使って提供者の情報を記述します。詳しくは[人型](#人型)を参照ください。
  - サービス提供者が法人などの組織の場合は、提供者プロパティの値型に組織型を型制約として指定し、組織型の各プロパティを使って提供者の情報を記述します。詳しくは[組織型](#組織型)を参照ください。

- サービスの利用方法の記述
  - サービスの利用方法について書くときは、利用方法プロパティ(xsd:string)に具体的な説明を記述します。

#### 例
|項目名	|構造化項目名	|値|
|:----|:----|:----|
|種別   |サービス型>種別   | 健康支援 |
|名称   |サービス型>表記   | 〇〇市定期歯科検診 |
|利用対象年齢(上)|サービス型>利用対象>制約{@範囲制約型}{制約対象='人型>年齢>数値'}>上限値{単位表記='歳'}>数値 | 40 |
|利用対象年齢(下)|サービス型>利用対象>制約{@範囲制約型}{制約対象='人型>年齢>数値'}>下限値{単位表記='歳'}>数値 | 40 |
|提供者  |サービス型>提供者{@組織型}>名称>表記  | 〇〇市   |
|利用方法 |サービス型>利用方法 | 定期歯科検診である旨を伝えて歯科を予約します。当日は送付されたはがきをお持ちください。 |

### [設備型](#設備型)
#### 概要
施設や建物に備わっている設備を記述するための型です。施設や建物の記述の一部であることも多いですが、それだけで記述されることもあります。施設等に固定されていることが多いですが、可搬な設備も書くことができます。

この型の上位は[事物型](#事物型)です。また、その上位は[概念型](#概念型)です。この型では事物型、概念型で用意されたプロパティも使われます。詳しくは[事物型](#事物型)、[概念型](#概念型)を参照してください。

#### 利用にあたってのヒント
- 種別に関する記述
  - 設備に種別があるときは、種別プロパティ(xsd:string)に設備の種類を記述します。
  - 設備の種類がコードとして用意されている場合は、種別コードプロパティ([コード型](#コード型))を使って記述します。詳しくは[コード型](#コード型)を参照ください。

- 設置されている建物や施設に関する記述
  - この設備が設置されている建物や施設を書くときには、設置地点プロパティ([地物型](#地物型))を使います。
  - 設置地点プロパティの値型は地物型ですが、実際にはその継承で作られている[建物型](#建物型)や[施設型](#施設型)を型制約として指定して使います。
    - 例えば、この設備が設置されている建物の名称や住所を書くときは、設置地点プロパティの値型に建物型を型制約として指定し、建物型の表記プロパティ(xsd:string)や住所プロパティ([住所型](#住所型))を使って記述します。
    - 詳しくは[地物型](#地物型)を参照ください。

- 建物や施設の中で設置されている位置に関する記述
  - 設備が建物や施設のどこに設置されているかについての情報を書くときは、設置位置プロパティ(xsd:string)に記述します。
  - 設置位置の例としては、階数(例:"12階")やフロア内の位置(例:"中央エリア")、目標物との関係(例:"中央玄関左側")などがあります。

- 利用可能時間の記述
  - 設備の利用可能な時間を書きたいときは、利用可能時間プロパティ([期間スケジュール型](#期間スケジュール型))を使います。
  - 利用可能時間プロパティの値型は期間スケジュール型ですが、実際にはその継承で作られている[期間型](#期間型)や[イベントスケジュール型](#イベントスケジュール型)あるいは[定期スケジュール型](#定期スケジュール型)を型制約として指定して記述します。
    - 例えば、平日9時から17時のみ利用可能であれば、利用可能時間プロパティの値型に定期スケジュール型を型制約として指定し、定期スケジュール型の開催期日プロパティ(xsd:string)に"月火水木金"と記述し、開始時間プロパティ(xsd:time)に"09:00:00"、終了時間プロパティ(xsd:time)に"17:00:00"と記述します。
    - 設置されている施設や建物に依存するケースなど時間が明示できない場合は、型制約として指定した値型の先の説明プロパティ(xsd:string)に記述します。詳しくは[期間型](#期間型)、[イベントスケジュール型](#イベントスケジュール型)、[定期スケジュール型](#定期スケジュール型)を参照ください。
  - 平日と休日で利用可能時間が異なるといった場合は、利用可能時間プロパティを複数回使って記述します。

- 設置者に関する記述
  - この設備を設置した組織を書くには設置者プロパティ([組織型](#組織型))を使います。
    - 例えば、設置した組織の名称を書くときは、設置者プロパティの先の表記プロパティ(xsd:string)に記述します。

- 連絡先や問い合わせ先の記述
  - この設備に関しての連絡先や問い合わせ先を書くときは、連絡先プロパティ([連絡先型](#連絡先型))を使います。
    - 例えば、連絡先の名称、電話番号、Eメールアドレスを書く場合、それぞれ、連絡先プロパティの先の表記プロパティ(xsd:string)、電話番号プロパティ([電話番号型](#電話番号型))、Eメールアドレスプロパティ(xsd:string)に記述します。

- バリアフリーに関する記述
  - この設備がバリアフリー対応であるかどうかや、どのようなバリアフリー対応がなされているかを書くには、バリアフリープロパティ(xsd:string)に記述します。

#### 例
|項目名|構造化項目名|値|
|:----|:----|:----|
|ID|*設備型>ID>識別値|EQ-EL1234|
|種別|設備型>種別|エレベータ|
|更新日|設備型>メタデータ>日付{種別='更新日'}>標準型日付|2020-10-10|
|表記|設備型>表記|第1市庁舎 西1エレベータ|
|説明|設備型>説明|△△電機ABC1234|
|設置建物|設備型>設置地点{@建物型}>表記|〇〇市第1市庁舎|
|住所|設備型>設置地点{@建物型}>住所>表記|〇〇市本町1-1-1|
|設置位置|設備型>設置位置|西側ホール|
|設置者|設備型>設置者>表記|◯◯市役所|
|設置者電話|設備型>設置者>連絡先>電話番号|0123-45-6789|
|管理者|設備型>管理者{@組織型}>表記|〇〇市役所総務部設備課|
|連絡先|設備型>連絡先>表記|〇〇市役所総務部設備課修繕係|
|連絡先電話|設備型>連絡先>電話番号|0123-45-6789|
|連絡先メール|設備型>連絡先>Eメールアドレス|shuzen@city.marumaru.lg.jp|
|設置年月日|設備型>設置日>標準型日付|1990-1-1|
|メーカー・機種|設備型>記述{種別='機種'}>説明|A社製　型番1234|
|バリアフリー|設備型>バリアフリー|車椅子対応|
|利用可能時間|設備型>利用可能時間{@期間型}>説明|市庁舎開庁時間内|

### [人型](#人型)
#### 概要
人に関わる情報を記述するための型です。

この型の上位は[実体型](#実体型)です。また、その上位は[事物型](#事物型)、[概念型](#概念型)です。この型では、実体型、事物型、概念型で用意されたプロパティも使われます。詳しくは[実体型](#実体型)、[事物型](#事物型)、[概念型](#概念型)を参照してください。

#### 利用にあたってのヒント
- 氏名の記述
  - 氏名を書くときは氏名プロパティ([氏名型](#氏名型))を使います。
  - 氏名プロパティの値型は氏名型で、このプロパティを使い分けることで、多様な氏名の書き方を記述することができます。
    - 氏名を姓、名と分けずに書くときは、姓名プロパティ(xsd:string)に記述します。
    - 氏名を姓と名を分けて書くときは、それぞれ、姓プロパティ(xsd:string)、名プロパティ(xsd:string)に記述します。
    - カタカナで氏名を書くときは、姓名カナ表記プロパティ(xsd:string)(分けずに書く場合)、姓カナ表記プロパティ(xsd:string)、名カナ表記プロパティ(xsd:string)に記述します。
    - ローマ字で氏名を書くときは、姓名ローマ字表記プロパティ(xsd:string)(分けずに書く場合)、姓ローマ字表記プロパティ(xsd:string)、名ローマ字表記プロパティ(xsd:string)に記述します。
    - ミドルネームがあるときは、ミドルネームプロパティ(xsd:string)、ミドルネームカナ表記プロパティ(xsd:string)、ミドルネームローマ字表記プロパティ(xsd:string)に記述します。
    - 詳しくは[氏名型](#氏名型)を参照ください。
  - 旧姓併記など、氏名が複数あるときは、氏名プロパティを複数回使い、氏名プロパティの先の種別プロパティ(xsd:string)に"旧姓"というように記述します。

- 住所の記述
  - 住所を書くときは、住所プロパティ([住所型](#住所型))を使います。
  - 住所型で住所を書くときは、表記プロパティ(xsd:string)を使って一つの文字列として記述することもできますし、都道府県プロパティ(xsd:string)、市区町村プロパティ(xsd:string)等を使って分けて記述することもできます。詳しくは[住所型](#住所型)を参照ください。
  - 住所が複数あるときは、住所プロパティを複数回使い、住所プロパティの先の種別プロパティ(xsd:string)に住所の種類を記述(例えば"帰省先")することができます。

- 生年月日、死亡年月日の記述
  - 生年月日と死亡年月日は、それぞれ生年月日プロパティ([日付型](#日付型))、死亡年月日プロパティ([日付型](#日付型))を使います。
  - 日付型で日付を書くときは、標準型日付プロパティ(xsd:date)や表記プロパティ(xsd:string)を使って一つの文字列として記述することもできますし、年号プロパティ(xsd:string)、年プロパティ(xsd:integer)、月プロパティ(xsd:integer)、日プロパティ(xsd:integer)等を使って分けて記述することもできます。詳しくは[日付型](#日付型)を参照ください。

- 身長、体重の記述
  - 身長と体重は、それぞれ身長プロパティ([数量型](#数量型)), 体重プロパティ([数量型](#数量型))を使います。
  - 数量型で長さ(距離)や重さ(重量)を書く場合は、数値プロパティ(xsd:decimal)と単位表記プロパティ(xsd:string)を使って記述します。
    - 例えば、長さ170cmであれば数値プロパティ(xsd:decimal)に"170"、単位表記プロパティ(xsd:string)に"cm"と記述し、重さ60kgであれば数値プロパティ(xsd:decimal)に"60"、単位表記プロパティ(xsd:string)に"kg"と記述します。

- 他の人との関係の記述
  - 他の人との関係を書きたいときは、関与プロパティ([関与型](#関与型))を使います。
  - 関与型には役割プロパティ(xsd:string)と関与者プロパティ([実体型](#実体型))があります。役割プロパティに関係の説明を記述し、関与者プロパティに関係する人を記述します。
    - 関与者プロパティの値型は実体型ですが、実際にはその継承で作られているる[人型](#人型)や[組織型](#組織型)を型制約として指定して使います。  
    - 例えば、配偶者の情報(氏名など)を書きたいときは、関与プロパティの先の役割プロパティ(xsd:string)の値として"配偶者"を記述します。また、関与者プロパティの値型に人型を型制約として指定し、人型の各プロパティを使って配偶者の情報を記述します。
    - 詳しくは[関与型](#関与型)を参照ください。
  - 複数の人との関係を記述する時は、関与プロパティを複数回使います。

- 組織との関係の記述
  - 所属組織や関係先など、組織との関係を書きたいときは、関与プロパティ([関与型](#関与型))を使います。
  - 関与プロパティには役割プロパティ(xsd:string)と関与者プロパティ([実体型](#実体型))があります。役割プロパティに関係の説明を入れ、関与者プロパティに関係する組織を記述します。
    - 関与者プロパティの値型は実体型ですが、実際にはその継承で作られている[人型](#人型)や[組織型](#組織型)を型制約として指定して使います。  
    - 例えば、勤務先の情報(名称など)を記述したい時は、関与プロパティの先の役割プロパティの値として"勤務先"を記述します。また、関与者プロパティの値型に組織型を型制約として指定し、組織型の各プロパティを使って勤務先の情報を記述します。
    - 詳しくは[関与型](#関与型)を参照ください。
  - 複数の組織との関係を記述する時は、関与プロパティを複数回使います。

- プロパティに用意されていない項目を書きたい時
  - 個別のプロパティとして用意されていない項目を書きたいときは、記述プロパティ([記述型](#記述型))を使って記述します。
    - 例えば、血液型を書く場合、記述プロパティの先の種別プロパティ(xsd:string)の値に"血液型"と記述し、記述プロパティの先の説明プロパティ(xsd:string)に実際の値("AB型"等)を記述します。
  - 複数の異なる項目があるときは、記述プロパティを複数回使います。

#### 例
|項目名|構造化項目名|値|
|:----|:----|:----|
|ID|*人型>ID>識別値|ID0123456|
|更新日|人型>メタデータ>日付{種別='更新日'}>標準型日付|2020-10-10|
|氏名(姓)|人型>氏名>姓|井美|
|氏名(名)|人型>氏名>名|太郎|
|氏名(ローマ字)|人型>氏名>姓名ローマ字表記|Imi Taro|
|氏名(カナ)|人型>氏名>姓名カナ表記|イミ　タロウ|
|性別|人型>性別|男|
|生年月日|人型>生年月日>標準型日付|2000-10-10|
|郵便番号|人型>住所>郵便番号|1234567|
|都道府県|人型>住所>都道府県|□□県|
|住所|人型>住所>表記|○○市××町1-1-1|
|電話番号|人型>連絡先>電話番号|0123-456-7890|
|Eメールアドレス|人型>連絡先>Eメールアドレス|taro.imi@imimail.com|
|所属|人型>関与[所属]{役割='所属'}>関与者{@組織型}>表記|○○市サッカークラブ|
|保護者|人型>関与[保護者]{役割='保護者'}>関与者{@人型}>氏名>姓名|井美一郎|
|保護者電話番号|人型>関与[保護者]{役割='保護者'}>関与者{@人型}>連絡先>電話番号|0123-456-7899|
|保護者メールアドレス|人型>関与[保護者]{役割='保護者'}>関与者{@人型}>連絡先>Eメールアドレス|ichiro.imi@imimail.com|
|保護者との関係|人型>記述[保護者との関係]{種別='保護者との関係'}>説明|父|
|保護者との連絡方法|人型>記述[保護者との連絡方法]{種別='保護者との連絡方法'}>説明|メールでの連絡を希望|
|本籍|人型>本籍>国|日本|
|出生地|人型>出生地>表記|oo県○○市|
|年齢|人型>年齢{単位表記='歳'}>数値|15|
|身長|人型>身長{単位表記='cm'}>数値|180|
|体重|人型>体重{単位表記='kg'}>数値|80|
|血液型|人型>記述[血液型]{種別='血液型'}>説明|AB型|

### [組織型](#組織型)
#### 概要
様々な組織の情報を記述するための型です。組織は必ずしも登記されている必要はなく、法人内部の部署などを記述する場合にも組織型を使用します。

この型の上位は[実体型](#実体型)です。その上位は[事物型](#事物型)、[概念型](#概念型)です。この型では、実体型、事物型、概念型で用意されたプロパティも使われます。詳しくは[実体型](#実体型)、[事物型](#事物型)、[概念型](#概念型)を参照してください。

#### 利用にあたってのヒント
- 名称の記述
  - 簡単に文字列として組織の名称を書きたいときは、表記プロパティ(xsd:string)に記述します。
  - 略称、別名といった通称がある場合は、通称プロパティ(xsd:string)に記述します。
  - 名称にカナ表記やローマ字表記もある場合は、名称プロパティ([名称型](#名称型))を使います。
  - 名称型でカナ表記やローマ字表記を書くときは、カナ表記プロパティ(xsd:string)やローマ字表記プロパティ(xsd:string)に記述します。詳しくは[名称型](#名称型)を参照ください。

- 活動の記述
  - 組織が行っている又は行った活動を書くときは、活動プロパティ([活動型](#活動型))を使って記述します。詳しくは[活動型](#活動型)を参照ください。

- 概要の記述
  - 組織の概要を書くときは、概要プロパティ(xsd:string)に記述します。

- 電話番号、メールアドレスなどの記述
  - 組織に関する電話番号、メールアドレス、書類の送付先などを書くときは、連絡先プロパティ([連絡先型](#連絡先型))を使います。
    - 例えば、連絡先の名称、電話番号、Eメールアドレスを書く場合、それぞれ、連絡先プロパティの先の表記プロパティ(xsd:string)、電話番号プロパティ([電話番号型](#電話番号型))、Eメールアドレスプロパティ(xsd:string)に記述します。

- 組織の構成員の人数の記述
  - 構成員の人数を書くときは、関連人員プロパティ([人数型](#人数型))を使います。
  - 人数型で人数を書く場合は、種別プロパティ(xsd:string)と、人数プロパティ(xsd:nonNegativeInteger)を使って記述します。
    - 例えば、従業員数が100名であれば、種別プロパティに"従業員数"、人数プロパティに"100"と記述します。

- 代表者の記述
  - 組織を代表する人の情報を書くときは、代表者プロパティ([構成員型](#構成員型))の先の構成員プロパティ([人型](#人型))を使って記述します。詳しくは[人型](#人型)を参照ください。

#### 例
|項目名	|構造化項目名	|値|
|:----|:----|:----|
|名称       |組織型>表記  | 〇〇会   |
|通称       |組織型>通称       | 〇タン   |
|説明       |組織型>説明       | 〇〇市内の自然の魅力を発信するための有志の会   |
|活動開始日時   |組織型>活動>期間{@期間型}>開始日時>標準型日時 | 2020-09-01T09:00:00 |
|主要な活動   |組織型>活動>説明 | 〇〇市の自然観察 |
|連絡先      |組織型>連絡先>電話番号  | 000-3333-4444|
|会員数    |組織型>関連人員{種別='会員'}>人数  | 10 |
|代表者      |組織型>代表者>構成員>氏名>姓名  | 山田　花子  |

### [業務組織型](#業務組織型)
#### 概要
組織のうち、事業費目や事業年度、代理人といった情報がある組織を記述するための型です。個人事業主など法人登記されていない業務組織を記述する時に使います。法人としての組織の記述のためにはこの型を継承した法人型があります。

この型の上位は[組織型](#組織型)です。その上位は[実体型](#実体型)、[事物型](#事物型)、[概念型](#概念型)です。この型では、組織型、実体型、事物型、概念型で用意されたプロパティも使われます。詳しくは[組織型](#組織型)、[実体型](#実体型)、[事物型](#事物型)、[概念型](#概念型)を参照してください。

#### 利用にあたってのヒント
- 名称の記述
  - 簡単に文字列として業務組織の名称を書きたいときは、表記プロパティ(xsd:string)に記述します。
  - 略称、別名といった通称がある場合は、通称プロパティ(xsd:string)に記述します。
  - 登記や届け出上の屋号または名称について書くときは、名称プロパティ([名称型](#名称型))を使います。
    - 屋号又は名称の種別は、名称プロパティの先の種別プロパティ(xsd:string)に"屋号"又は"名称"と記述します。
    - 屋号または名称は、名称プロパティの先の表記プロパティ(xsd:string)に記述します。
    - 屋号または名称のカナ表記やローマ字表記を書くときは、名称プロパティの先のカナ表記プロパティ(xsd:string)やローマ字表記プロパティ(xsd:string)に記述します。
    - 詳しくは[名称型](#名称型)を参照ください。

- 事業種目の記述
  - 個人事業主登録されている事業種目は、事業種目プロパティ(xsd:string)に記述します。

- 事業年度開始日の記述
  - 事業年度が開始する月日を書くときは、事業年度開始日プロパティ([日付型](#日付型))を使います。
    - 例えば、事業年度が4月1日から翌年3月31日であれば、事業年度開始プロパティの先の月プロパティ(xsd:integer)に"4"を日プロパティ(xsd:integer)に"1"を記述します。

#### 例
|項目	|構造化項目名	|値|
|:----|:----|:----|
|商号種別   |業務組織型>名称>種別   | 屋号 |
|商号   |業務組織型>名称>表記   | 〇〇商店 |
|事業種目   |業務組織型>事業種目   | 雑貨の販売 |
|事業年度開始月 |業務組織型>事業年度開始日>月 | 4 |
|事業年度開始日 |業務組織型>事業年度開始日>日 | 1 |

### [法人型](#法人型)
#### 概要
会社などの法人を記述するための型です。法人型は[法人インフォーメーション](https://hojin-info.go.jp/hojin/TopPage)にて使用されています。法人インフォーメーションでは、下記解説以外にも記述する内容が詳細に規定されているプロパティ及び拡張されたプロパティがあります。

この型の上位は[業務組織型](#業務組織型)です。その上位は[組織型](#組織型)、[実体型](#実体型)、[事物型](#事物型)、[概念型](#概念型)です。この型では、業務組織型、組織型、実体型、事物型、概念型で用意されたプロパティも使われます。詳しくは[業務組織型](#業務組織型)、[組織型](#組織型)、[実体型](#実体型)、[事物型](#事物型)、[概念型](#概念型)を参照してください。

#### 利用にあたってのヒント
- 法人番号の記述
  - IDプロパティ([ID型](#id型))の先の種別プロパティ(xsd:string)に、"法人番号"と記述します。
  - IDプロパティ([ID型](#id型))の先の識別値プロパティ(xsd:string)に、法人番号の13桁の数字を文字列として記述します。

- 法人名の記述
  - 簡単に文字列として組織の名称を書きたいときは、表記プロパティ(xsd:string)に記述します。
  - 略称、別名といった通称がある場合は、通称プロパティ(xsd:string)に記述します。
  - 登記や届け出上の屋号または名称について書くときは、名称プロパティ([名称型](#名称型))を使います。
    - 屋号又は名称の種別は、名称プロパティの先の種別プロパティ(xsd:string)に"屋号"又は"名称"と記述します。
    - 屋号または名称は、名称プロパティの先の表記プロパティ(xsd:string)に記述します。
    - 屋号または名称のカナ表記やローマ字表記を書くときは、名称プロパティの先のカナ表記プロパティ(xsd:string)やローマ字表記プロパティ(xsd:string)に記述します。
    - 詳しくは[名称型](#名称型)を参照ください。

- 住所の記述
  - 住所を書くときは、住所プロパティ([住所型](#住所型))を使います。
  - 住所型で住所を書くときは、表記プロパティ(xsd:string)を使って、一つの文字列として記述することもできますし、都道府県プロパティ(xsd:string)、市区町村プロパティ(xsd:string)等を使って、分けて記述することもできます。
  - 住所が複数あるときは、住所プロパティを複数回使い、住所プロパティの先の種別プロパティ(xsd:string)に住所の種類を記述(例えば"本社所在地"や"登記上の住所")します。
  - 住所プロパティでは、できるだけ、都道府県コードなどのコードを記述します。詳しくは[住所型](#住所型)を参照ください。

- 組織種別の記述
  - 法人の組織種別を表すコード(国税庁法人番号公表サイトの「リソース定義書」http://www.houjin-bangou.nta.go.jp/documents/k-resource-dl.pdf で定められた3桁のコード)は組織種別プロパティ([コード型](#コード型))の先の識別値プロパティ(xsd:string)に記述します。

- 役員などの記述
  - 役員など法人に関係する人物などの情報を書くときは、関与プロパティ([関与型](#関与型))を使います。
  - 関与型には役割プロパティ(xsd:string)と関与者プロパティ([実体型](#実体型))があります。役割プロパティに関係の説明を記述し、関与者プロパティに関係する人を記述します。
    - 関与者プロパティの値型は実体型ですが、実際にはその継承で作られている[人型](#人型)や[組織型](#組織型)を型制約として指定して使います。  
    - 例えば、役員の情報(氏名など)を書きたいときは、関与プロパティの先の役割プロパティ(xsd:string)の値として"役員"を記述します。また、関与者プロパティの値型に人型を型制約として指定し、人型の各プロパティを使って役員の情報を記述します。
    - 詳しくは[関与型](#関与型)を参照ください。

- 従業員数などの記述
  - 構成員の人数を書くときは、関連人員プロパティ([人数型](#人数型))を使います。
  - 人数型で人数を書く場合は、種別プロパティ(xsd:string)と、人数プロパティ(xsd:nonNegativeInteger)を使って記述します。
    - 例えば、従業員数が100名であれば、種別プロパティに"従業員数"、人数プロパティに"100"と記述します。

#### 例
|項目	|構造化項目名	|値|
|:----|:----|:----|
|法人番号 |法人型>ID{種別='法人番号'}>識別値 |5010005007126 |
|法人名称|法人型>名称{種別='名称'}>表記| 〇〇株式会社   |
|組織種別  |法人型>組織種別>識別値  | 301  |
|資本金   |法人型>資本金{通貨='円'}>数値 | 10000000   |
|従業員数  |法人型>関連人員{種別='従業員数'}>人数  | 100   |
|役員  |法人型>関与{役割='役員'}>関与者{@人型}>氏名>姓名  | 山田　花子   |

### [場所型](#場所型)
#### 概要
地上にある地点や領域などを記述するための型です。なんらかの管理や運営がなされている場合は、この型を継承して定義している[地物型](#地物型)を使うとよいでしょう。また、さらに地物型を継承して[施設型](#施設型)、[建物型](#建物型)、[土地型](#土地型)が用意されているので、記述対象がこれらに相当するものであれば、それぞれの対応する型を使うのがよいでしょう。

この型の上位は[事物型](#事物型)です。また、その上位は[概念型](#概念型)です。事物型と概念型で用意されたプロパティも場所型では使われます。詳しくは[事物型](#事物型)と[概念型](#概念型)を参照してください。

### [地物型](#地物型)
#### 概要
地上にある施設や建物、土地などで、なんらかの管理や運営がなされている対象を記述するために用意された型です。この型を継承した、[施設型](#施設型)、[建物型](#建物型)、[土地型](#土地型)が用意されているので、記述対象がこれらに相当するものであれば、それぞれの対応する型を使うのがよいでしょう。

この型の上位は[場所型](#場所型)です。また、その上位は[事物型](#事物型)、[概念型](#概念型)です。場所型、事物型、概念型で用意されたプロパティも地物型では使われます。詳しくは[場所型](#場所型)、[事物型](#事物型)、[概念型](#概念型)を参照してください。

#### 利用にあたってのヒント
- 地理座標の記述
  - 記述対象の地理的情報を書くときは、地理座標プロパティ([座標型](#座標型))を使います。
  - 座標型で記述対象を代表する地点の緯度・経度を書く場合は、座標型の緯度プロパティ(xsd:string)、経度プロパティ(xsd:string)を使いそれぞれの値を記述します。
  - 座標型を使って、緯度・経度の指定による地点の記述以外にも、線、領域(ポリゴン)を記述することができます。この場合は、座標型の座標データプロパティ(xsd:string)に記述します。詳しくは[座標型](#座標型)を参照ください。

- 関係している人や組織の記述
  - 管理者や担当者といった記述対象に関係する人や組織を書きたいときは、関与プロパティ([関与型](#関与型))を使います。
  - 関与型には役割プロパティ(xsd:string)と関与者プロパティ([実体型](#実体型))があります。役割プロパティに関係の説明を記述し、関与者プロパティに関係する人や組織を記述します。
    - 関与者プロパティの値型は実体型ですが、実際にはその継承で作られている[人型](#人型)や[組織型](#組織型)を型制約として指定して使います。  
    - 例えば、管理者としてある担当組織を書きたい場合、関与プロパティの先の役割プロパティ(xsd:string)の値として"管理者"といった説明を記述します。また、関与者プロパティの値型に組織型を型制約として指定し、組織型の各プロパティを使って担当組織を記述します。
    - 詳しくは[関与型](#関与型)を参照ください。

#### 例
|項目名|構造化項目名|値|
|:----|:----|:----|
|ID|*地物型>ID>識別値|AREA1234|
|名称|地物型>表記|駅前規制エリア|
|種別|地物型>種別|交通規制|
|画像|地物型>画像>|https://kisei.marumaru-city.lg.jp/kisei/imag.jpg|
|説明|地物型>説明|2020年8月1日の○○市花火大会開催時における駅前車両規制領域です。|
|範囲|地物型>地理座標>座標データ|35.680213 139.765239, 35.680413 139.764225, 35.682910 139.765099, 35.682727 139.766162|
|管理者|地物型>関与{役割='管理者'}>関与者{@組織型}>表記|○○警察署交通課|
|管理者電話番号|地物型>関与{役割='管理者'}>関与者{@組織型}>連絡先>電話番号|0123-45-6789|
|更新日時|地物型>メタデータ>日時{種別='更新日時'}>標準型日時|2020-07-31T09:00:00|

### [土地型](#土地型)
#### 概要
特定の用途に用いられている土地を記述するための型です。

この型の上位は[地物型](#地物型)です。また、その上位は[場所型](#場所型)、[事物型](#事物型)、[概念型](#概念型)です。この型では、地物型、場所型、事物型、概念型で用意されたプロパティも使われます。詳しくは[地物型](#地物型)、[場所型](#場所型)、[事物型](#事物型)、[概念型](#概念型)を参照してください。

#### 利用にあたってのヒント
- 面積の記述
  - 面積を書くときは、面積プロパティ([面積型](#面積型))を使います。
  - 面積型で面積を書く場合は、単位表記プロパティ(xsd:string)と、数値プロパティ(xsd:decimal)を使って記述します。
    - 例えば300m^2(平米)と書く場合は、面積型の単位表記プロパティ(xsd:string)の値に"m2(平米)"と記述し、数値プロパティ(xsd:decimal)に"300"と記述します。

### [建物型](#建物型)
#### 概要
居住、仕事、娯楽等何らかの役割のために建てられた建物(建造物、建築物、家屋)を記述するための型です。建物自体に備わった情報を主に記述します。建物が施設として用いられる時は、施設としての情報は施設型を使って記述して、この建物を使う施設の情報として分けて記述することもできます。

この型の上位は[地物型](#地物型)です。また、その上位は[場所型](#場所型)、[事物型](#事物型)、[概念型](#概念型)です。この型では、地物型、場所型、事物型、概念型で用意されたプロパティも使われます。詳しくは[地物型](#地物型)、[場所型](#場所型)、[事物型](#事物型)、[概念型](#概念型)を参照してください。

#### 利用にあたってのヒント
- 名称の記述
  - 簡単に文字列として施設の名称を書きたいときは、表記プロパティ(xsd:string)に記述します。
  - 略称、別名といった通称がある場合は、通称プロパティ(xsd:string)に記述します。
  - 名称にカナ表記やローマ字表記もある場合は、名称プロパティ([名称型](#名称型))を使います。
  - 名称型でカナ表記やローマ字表記を書くときは、カナ表記プロパティ(xsd:string)やローマ字表記プロパティ(xsd:string)に記述します。詳しくは[名称型](#名称型)を参照ください。

- 外部Webページや画像の記述
  - 建物のWebページを示すときは、参照プロパティ([参照型](#参照型))の先の参照先プロパティ(xsd:anyURI)に具体的なURLを記述します。詳しくは[参照型](#参照型)を参照ください。
  - 建物を代表する画像を示すときは、画像プロパティ(xsd:anyURI)に具体的なURLを記述します。

- 住所の記述
  - 建物を代表する住所を書く時は、住所プロパティ([住所型](#住所型))を使います。
  - 住所型で住所を書くときは、表記プロパティ(xsd:string)を使って、一つの文字列として記述することもできますし、都道府県プロパティ(xsd:string)、市区町村プロパティ(xsd:string)等を使って、分けて記述することもできます。詳しくは[住所型](#住所型)を参照ください。

- 地理座標の記述
  - 建物を代表する地点の緯度・経度を書くときは、地理座標プロパティ([座標型](#座標型))を使います。
  - 座標型で地点の緯度・経度を書く場合は、座標型の緯度プロパティ(xsd:string)、経度プロパティ(xsd:string)を使い、それぞれの値を記述します。詳しくは[座標型](#座標型)を参照ください。

- アクセスの記述
  - 施設へのアクセス方法を書く時は、アクセスプロパティ([アクセス型](#アクセス型))を使います。
  - アクセス型でアクセス方法を書くときは、始点プロパティ([地物型](#地物型))や終点プロパティ([地物型](#地物型))等を使って分けて記述することもできますし、備考プロパティ(xsd:string)を使って一つの文字列として記述することもできます。詳しくは[アクセス型](#アクセス型)を参照ください。
  - アクセス方法が複数あるときは、アクセスプロパティを複数回使って記述します。

- 設備の記述
  - 建物に設置されている設備(例えば、トイレやエレベータ)を書きたいときは、設備プロパティ([設備型](#設備型))を使います。
  - 設備型で設備の場所を説明文として書きたいときは、設備型の設置位置プロパティ(xsd:string)に記述します。
  - 緯度経度等、設備の場所をより詳しく書きたいときは、設備型の設置地点プロパティ([地物型](#地物型))を使って記述します。詳しくは[設備型](#設備型)を参照ください。
  - 設備が複数ある場合、設備プロパティを複数回使って記述します。

- 建物に関係している人や組織の記述
  - 管理者や担当者といった施設に関係する人や組織を書きたいときは、関与プロパティ([関与型](#関与型))を使います。
  - 関与型には役割プロパティ(xsd:string)と関与者プロパティ([実体型](#実体型))があります。役割プロパティに関係の説明を記述し、関与者プロパティに関係する人や組織を記述します。
    - 関与者プロパティの値型は実体型ですが、実際にはその継承で作られている[人型](#人型)や[組織型](#組織型)を型制約として指定して使います。  
    - 例えば、管理者としてある担当組織を書きたい場合、関与プロパティの先の役割プロパティ(xsd:string)の値として"管理者"といった説明を記述します。また、関与者プロパティの値型に組織型を型制約として指定し、組織型の各プロパティを使って担当組織を記述します。
    - 詳しくは[関与型](#関与型)を参照ください。

- 敷地面積、建築面積、延べ面積の記述
  - 敷地面積、建築面積、延べ面積を書くときは、それぞれ敷地面積プロパティ([面積型](#面積型))、建築面積プロパティ([面積型](#面積型))、延べ面積プロパティ([面積型](#面積型))を使います。
  - 面積型で面積を書く場合は、単位表記プロパティ(xsd:string)と、数値プロパティ(xsd:decimal)を使って記述します。
    - 例えば300m^2(平米)と書く場合は、面積型の単位表記プロパティ(xsd:string)の値に"m2(平米)"と記述し、数値プロパティ(xsd:decimal)に"300"と記述します。

- 建物に関連する施設の記述
  - 建物を使っている施設に関する説明を書くときには、施設プロパティ([施設型](#施設型))を使います。
  - 建物の中に複数の施設がある場合でも、建物全体がその施設の場合でも、複数の建物が一つの施設として使われている場合でも、施設プロパティを使って関係する施設の説明を記述します。
  - 建物の中に複数の施設がある場合は、施設プロパティを複数回使って記述します。
  - 必ずしも、施設と建物を分けて記述する必要はありません。特に一つの施設が一つの建物に対応している場合、どちらかの記述だけで十分な場合があります。施設が建物の一部を利用している場合や施設が複数の建物を利用している場合は、建物を分けて記述する方がわかりやすいでしょう。
  - 住所やアクセス、連絡先といった情報は、施設と建物のどちらでも記述できます。どちらに書くか(あるいは両方に書くか)は、目的や状況によって決めると良いでしょう。

#### 例
|項目名|構造化項目名|値|
|:----|:----|:----|
|ID|*建物型>ID>識別値|MM-SG00101|
|建物名称|建物型>表記|○○市立xx小学校第1校舎|
|住所|建物型>住所>表記|○○市xx町1-2-3|
|緯度|建物型>地理座標>緯度|35.683934	|
|経度|建物型>地理座標>経度 |139.75289000000001|
|設備|建物型>設備[1階トイレ]>表記|1階トイレ|
|  |建物型>設備[1階トイレ]>説明|男性用:3、女性用:6、多目的トイレ:1|
|  |建物型>設備[1階トイレ]>設置位置|1階玄関横|
|  |建物型>設備[1階トイレ]>バリアフリー|多目的トイレは車椅子用設備、オストメイト対応設備あり|
|  |建物型>設備[エレベータ]>表記|エレベータ|
|  |建物型>設備[エレベータ]>設置位置|階段横|
|  |建物型>設備[エレベータ]>バリアフリー|車椅子対応|
|管理者|建物型>関与{役割='管理者'}>関与者{@組織型}>表記|○○市教育部総務課|
|管理者電話|建物型>関与{役割='管理者'}>関与者{@組織型}>連絡先>電話番号|0123-456-7890|
|主要用途|建物型>主要用途|普通教室、特別教室等|
|敷地面積|建物型>敷地面積{単位表記='m2(平米)'}>数値|2000|
|建築面積|建物型>建築面積{単位表記='m2(平米)'}>数値|1000|
|延べ面積|建物型>延べ面積{単位表記='m2(平米)'}>数値|3000|
|地上階数|建物型>地上階数|3|
|地下階数|建物型>地下階数|1|
|構造|建物型>構造|鉄筋コンクリート造り|
|竣工日|建物型>竣工日>標準型日付|1990-10-10|
|施設|建物型>施設>表記|○○市立xx小学校|

### [施設型](#施設型)
#### 概要
娯楽施設、医療施設、交通施設など、ある目的のために用いられる建造物やその設備を施設として記述するための型です。  
多くの施設は建物が設置されていますが、施設型には施設として持つ情報を記述します。設置されている建物の情報の記述が必要な時は[建物型](#建物型)として記述し、施設型の建物プロパティで指し示します。

この型の上位は[地物型](#地物型)です。また、その上位は[場所型](#場所型)、[事物型](#事物型)、[概念型](#概念型)です。この型では、地物型、場所型、事物型、概念型で用意されたプロパティも使われます。詳しくは[地物型](#地物型)、[場所型](#場所型)、[事物型](#事物型)、[概念型](#概念型)を参照してください。

#### 利用にあたってのヒント
- 名称の記述
  - 簡単に文字列として施設の名称を書きたいときは、表記プロパティ(xsd:string)に記述します。
  - 略称、別名といった通称がある場合は、通称プロパティ(xsd:string)に記述します。
  - 名称にカナ表記やローマ字表記もある場合は、名称プロパティ([名称型](#名称型))を使います。
  - 名称型でカナ表記やローマ字表記を書くときは、カナ表記プロパティ(xsd:string)やローマ字表記プロパティ(xsd:string)に記述します。詳しくは[名称型](#名称型)を参照ください。

- 外部Webページや画像の記述
  - 施設のWebページを示すときは、参照プロパティ([参照型](#参照型))の先の参照先プロパティ(xsd:anyURI)に具体的なURLを記述します。詳しくは[参照型](#参照型)を参照ください。
  - 施設を代表する画像を示すときは、画像プロパティ(xsd:anyURI)に具体的なURLを記述します。

- 住所の記述
  - 施設を代表する住所を書く時は、住所プロパティ([住所型](#住所型))を使います。
  - 住所型で住所を書くときは、表記プロパティ(xsd:string)を使って、一つの文字列として記述することもできますし、都道府県プロパティ(xsd:string)、市区町村プロパティ(xsd:string)等を使って、分けて記述することもできます。詳しくは[住所型](#住所型)を参照ください。

- 地理座標の記述
  - 施設を代表する地点の緯度・経度を書くときは、地理座標プロパティ([座標型](#座標型))を使います。
  - 座標型で地点の緯度・経度を書く場合は、座標型の緯度プロパティ(xsd:string)、経度プロパティ(xsd:string)を使い、それぞれの値を記述します。詳しくは[座標型](#座標型)を参照ください。

- アクセスの記述
  - 施設へのアクセス方法を書く時は、アクセスプロパティ([アクセス型](#アクセス型))を使います。
  - アクセス型でアクセス方法を書くときは、始点や終点などを分けて記述することもできますし、備考プロパティ(xsd:string)を使って単に文字列として記述することもできます。詳しくは[アクセス型](#アクセス型)を参照ください。
  - アクセス方法が複数あるときは、アクセスプロパティを複数回使って記述します。

- 連絡先の記述
  - 連絡先を書く場合は、連絡先プロパティ([連絡先型](#連絡先型))を使います。
  - 連絡先型で単に連絡先を文字列で書きたいときは、連絡先型の表記プロパティ(xsd:string)に記述します。
    - 担当者名、住所、電話番号などを書きたいときは、連絡先型の担当者名プロパティ([氏名型](#氏名型))、住所プロパティ([住所型](#住所型)), 電話番号プロパティ([電話番号型](#電話番号型))を使うことができます。
    - 詳しくは[連絡先型](#連絡先型)を参照ください。

- 設備の記述
  - 施設に設置されている設備(例えば、トイレやエレベータ)を書きたいときは、設備プロパティ([設備型](#設備型))を使います。
  - 設備型で設備の場所を説明文として書きたいときは、設備型の設置位置プロパティ(xsd:string)に記述します。
  - 緯度経度等、設備の場所をより詳しく書きたいときは、設備型の設置地点プロパティ([地物型](#地物型))を使って記述します。詳しくは[設備型](#設備型)を参照ください。
  - 設備が複数ある場合、設備プロパティを複数回使って記述します。

- 施設に関係している人や組織の記述
  - 管理者や担当者といった施設に関係する人や組織を書きたいときは、関与プロパティ([関与型](#関与型))を使います。
  - 関与型には役割プロパティ(xsd:string)と関与者プロパティ([実体型](#実体型))があります。役割プロパティに関係の説明を記述し、関与者プロパティに関係する人や組織を記述します。
    - 関与者プロパティの値型は実体型ですが、実際にはその継承で作られている[人型](#人型)や[組織型](#組織型)を型制約として指定して使います。  
    - 例えば、管理者としてある担当組織を書きたい場合、関与プロパティの先の役割プロパティ(xsd:string)の値として"管理者"といった説明を記述します。また、関与者プロパティの値型に組織型を型制約として指定し、組織型の各プロパティを使って担当組織を記述します。
    - 詳しくは[関与型](#関与型)を参照ください。

- 利用可能時間の記述
  - 施設が利用可能な時間を書きたいときは、利用可能時間プロパティ([期間スケジュール型](#期間スケジュール型))を使います。
  - 利用可能時間プロパティの値型は期間スケジュール型ですが、実際にはその継承で作られている[期間型](#期間型)や[イベントスケジュール型](#イベントスケジュール型)あるいは[定期スケジュール型](#定期スケジュール型)を型制約として指定して使います。
    - 例えば、平日9時から17時のみ利用可能であれば、利用可能時間プロパティの値型に定期スケジュール型を型制約として指定し、定期スケジュール型の開催期日プロパティ(xsd:string)に"月火水木金"と記述し、開始時間プロパティ(xsd:time)に"09:00:00"、終了時間プロパティ(xsd:time)に"17:00:00"と記述します。
    - 詳しくは[期間スケジュール型](#期間スケジュール型)を参照ください。
  - 平日と休日で利用可能時間が異なるといった場合は、利用可能時間プロパティを複数回使って記述します。

- 料金の記述
  - 施設の利用料金を書くときは、料金プロパティ([価格型](#価格型))を使います。
  - 価格型で料金を書く場合は、料金の対象とその金額についてそれぞれ表記プロパティ(xsd:string)と金額プロパティ([金額型](#金額型))を使って記述します。
    - 金額型で金額を書く場合は、金額の値と通貨の種類をそれぞれ数値プロパティ(xsd:decimal)と通貨プロパティ(xsd:string)を使って記述します。
      - 例えば、入場料金300円という場合、料金プロパティの先の表記プロパティ(xsd:string)に"入場料金"と記述し、金額プロパティの先の数値プロパティ(xsd:decimal)に"300"、通貨プロパティ(xsd:string)に"円"と記述します。
  - 料金に種別があるときは、料金プロパティを複数回使って記述します。
    - 例えば、大人料金、子供料金の区別があるときは、料金プロパティの先の種別プロパティ(xsd:string)に"大人料金"あるいは"子供料金"と記述することで区別します。

- 収容人数の記述
  - 施設の収容人数を書く場合は、収容人数プロパティ([数量型](#数量型))を使います。
  - 数量型で人数を書くときは、数値プロパティ(xsd:decimal)にその人数を記述し、単位表記プロパティ(xsd:string)に"人"と記述します。
    - 例えば、収容人数が500人という場合、収容人数プロパティの先の数値プロパティ(xsd:decimal)に"500"と記述し、単位表記プロパティ(xsd:string)に"人"と記述します。
  - 大人子供の区別や利用形態の区別(スクール形式あるいは会議形式)といった収容人数に種類がある場合、収容人数プロパティを複数回使い、収容人数プロパティの先の種別プロパティ(xsd:string)にその区別の説明を記述します。

- 駐車場の記述
  - 施設の駐車場について書く場合には、駐車場プロパティ([駐車場型](#駐車場型))を使います。
  - 駐車場型で駐車場の種別(立体駐車場など)や収容台数を書きたい場合は、駐車場の種別を駐車場種別プロパティ(xsd:string)に、収容台数を収容台数プロパティ(xsd:integer)に記述します。 詳しくは[駐車場型](#駐車場型)を参照ください。
  - 駐車場が複数ある場合は駐車場プロパティを複数回使って記述します。駐車場の区別が必要な時は、駐車場プロパティの先の駐車場種別プロパティ(xsd:string)に記述します。

- 施設が設置されている建物の記述
  - 施設が設置されている建物に関して書きたいときは、建物プロパティ([建物型](#建物型))を使います。
  - 建物の一部を施設として使っている場合でも、建物全体がその施設の場合でも、複数の建物がその施設として使われている場合でも、建物プロパティを使って、それ(それら)の建物の説明を記述します。
  - 必ずしも、施設と建物を分けて記述する必要はありません。特に一つの施設が一つの建物に対応している場合、どちらかの記述だけで十分な場合があります。施設が建物の一部を利用している場合や施設が複数の建物を利用している場合は、建物を分けて記述する方がわかりやすいでしょう。
  - 住所やアクセス、連絡先といった情報は、施設と建物のどちらでも記述できます。どちらに書くか(あるいは両方に書くか)は、目的や状況によって決めると良いでしょう。

- 関連施設の記述
  - 施設の一部として別の施設がある場合やその逆で施設が別の施設の一部になっている場合など、施設に他の施設との関係がある時には、関連施設プロパティ([施設関連型](#施設関連型))を使って記述します。
    - 例えば、ある施設が別の施設を含んでいる場合、関連施設プロパティの先の役割プロパティ(xsd:string)の値として"下位施設"を記述し、施設プロパティ([施設型](#施設型))に別の施設を記述します。

#### 例
|項目	|構造化項目名	|値|
|:----|:----|:----|
|ID	|*施設型>ID>識別値	|M7005	|
|名称	|施設型>表記|△△市立AA高等学校	|
|名称よみ	|施設型>名称>カナ表記	|△△イチリツエーエーコウトウガッコウ	|
|郵便番号	|施設型>住所>郵便番号	|236-0027	|
|住所	|施設型>住所>表記	|○○県△△市××区瀬戸22-1	|
|緯度	|施設型>地理座標>緯度	|35.3354	|
|経度	|施設型>地理座標>経度	|139.618678	|
|電話番号	|施設型>連絡先>電話番号	|045-781-0000	|
|FAX番号	|施設型>連絡先>FAX番号	|045-788-0000	|
|利用交通機関	|施設型>アクセス>備考	|XXX駅から徒歩5分	|
|リンク	|施設型>参照>参照先>	|http://www.edu.city.example.jp/	|

|項目名|構造化項目名|値|
|:----|:----|:----|
|ID|*施設型>ID>識別値|ABC01234|
|名称|施設型>表記|XX保育園△△園　一時預かり施設|
|URL|施設型>参照>参照先>|https://example.com/|
|住所|施設型>住所>表記|○○市□□町1-1-1 △△駅ビル内|
|アクセス|施設型>アクセス>備考|△△駅直結|
|電話|施設型>連絡先>電話番号|03-1234-0000|
|FAX|施設型>連絡先>FAX番号|03-1234-0000|
|園設備|施設型>設備>表記|簡易滑り台他|
|運営事業者名称|施設型>関与{役割='運営事業者'}>関与者{@組織型}>表記|学校法人 XX保育会|
|運営事業者法人番号|施設型>関与{役割='運営事業者'}>関与者{@組織型}>ID{種別='法人番号'}>識別値|5010005007126 |
|保育時間(開始時間)|施設型>利用可能時間{@定期スケジュール型}>開始時間|09:00:00|
|保育時間(終了時間)|施設型>利用可能時間{@定期スケジュール型}>終了時間|18:00:00|
|利用料金(会員1時間)|施設型>料金{種別='会員'}{表記='1時間毎'}>金額{通貨='円'}>数値|300|
|利用料金(非会員1時間)|施設型>料金{種別='非会員'}{表記='1時間毎'}>金額{通貨='円'}>数値|500|
|受け入れ人数|施設型>収容人数{単位表記='人'}>数値|20|
|駐車場|施設型>駐車場{備考='駅ビル共通駐車場'}>収容台数|100|
|施設設置場所|施設型>建物>表記|△△駅ビル|
|施設設置場所URL|施設型>建物>参照>参照先>|https://sankaku.com/ekibiru/|
|運営施設|施設型>関連施設{役割='姉妹保育園'}>施設>表記|XX保育園▽▽園|

### [駐車場型](#駐車場型)
#### 概要
駐車場の情報を記述するための型です。

この型の上位は[施設型](#施設型)です。また、その上位は[地物型](#地物型)、[場所型](#場所型)、[事物型](#事物型)、[概念型](#概念型)です。この型では、施設型、地物型、場所型、事物型、概念型で用意されたプロパティも使われます。詳しくは[施設型](#施設型)、[地物型](#地物型)、[場所型](#場所型)、[事物型](#事物型)、[概念型](#概念型)を参照してください。

#### 利用にあたってのヒント
- 利用可能時間の記述
  - 駐車場が利用可能な時間を書きたいときは、利用可能時間プロパティ([期間スケジュール型](#期間スケジュール型))を使います。
  - 利用可能時間プロパティの値型は期間スケジュール型ですが、実際にはその継承で作られている[期間型](#期間型)や[イベントスケジュール型](#イベントスケジュール型)あるいは[定期スケジュール型](#定期スケジュール型)を型制約として指定して使います。
    - 例えば、平日9時から17時のみ利用可能であれば、利用可能時間プロパティの値型に定期スケジュール型を型制約として指定し、定期スケジュール型の開催期日プロパティ(xsd:string)に"月火水木金"と記述し、開始時間プロパティ(xsd:time)に"09:00:00"、終了時間プロパティ(xsd:time)に"17:00:00"と記述します。
  - 設置されている施設や建物に依存するケースなど時間が明示できない場合は、利用可能時間プロパティの先の説明プロパティ(xsd:string)に記述します。詳しくは[期間スケジュール型](#期間スケジュール型)を参照ください。
  - 平日と休日で利用可能時間が異なるといった場合は、利用可能時間プロパティを複数回使って記述します。

- 料金の記述
  - 駐車料金を書くときは、料金プロパティ([価格型](#価格型))を使います。
  - 価格型で料金を書く場合は、料金の対象とその金額についてそれぞれ表記プロパティ(xsd:string)と金額プロパティ([金額型](#金額型))を使って記述します。
    - 金額型で金額を書く場合は、金額の値と通貨の種類をそれぞれ数値プロパティ(xsd:decimal)と通貨プロパティ(xsd:string)を使って記述します。
      - 例えば、普通車一時間500円という場合、料金プロパティの先の表記プロパティ(xsd:string)に"普通車一時間"と記述し、金額プロパティの先の数値プロパティ(xsd:decimal)に"500"、通貨プロパティ(xsd:string)に"円"と記述します。
  - 駐車料金に種別があるときは、料金プロパティを複数回使って記述します。
    - 例えば、普通車一時間、大型車一時間の区別があるときは、料金プロパティの先の種別プロパティ(xsd:string)に"普通車一時間"あるいは"大型車一時間"と記述することで区別します。

- 設置されている建物に関する記述
  - 駐車場が建物内に設置されている場合は、その建物を建物プロパティ([建物型](#建物型))を使って記述します。詳しくは[建物型](#建物型)を参照ください。

- 関連施設の記述
  - この駐車場を利用している施設や関連する施設を書くときには、関連施設プロパティ([施設関連型](#施設関連型))を使います。
  - 施設関連型で関連施設を書くときは、役割プロパティ(xsd:string)に"提携"など施設との関係を記述して、施設プロパティ([施設型](#施設型))に実際の施設を記述します。詳しくは[施設型](#施設型)を参照ください。

#### 例
|項目名|構造化項目名|値|
|:----|:----|:----|
|ID|*駐車場型>ID>識別値|ABC01234|
|名称|駐車場型>表記|〇〇市役所第1駐車場|
|住所|駐車場型>住所>表記|○○市□□町1-1-1 △△|
|電話|駐車場型>連絡先>電話番号|03-1234-0000|
|運営事業者名称|駐車場型>関与{役割='運営事業者'}>関与者{@組織型}>表記|〇〇市役所|
|運営事業者法人番号|駐車場型>関与{役割='運営事業者'}>関与者{@組織型}>ID{種別='法人番号'}>識別値|5010005007126 |
|利用可能時間(開始)|駐車場型>利用可能時間{@定期スケジュール型}>開始時間|09:00:00|
|利用可能時間(終了)|駐車場型>利用可能時間{@定期スケジュール型}>終了時間|20:00:00|
|利用料金(普通乗用車)|駐車場型>料金{種別='普通車1時間'}>金額{通貨='円'}>数値|300|
|利用料金(軽自動車)|駐車場型>料金{種別='軽自動車1時間'}>金額{通貨='円'}>数値|200|
|設置ビル|駐車場型>建物>表記|〇〇市役所中央総合庁舎|
|収容台数|駐車場型>収容台数|50|
|駐車場利用施設|駐車場型>関連施設{役割='利用施設'}>施設[1]>表記|〇〇市役所|
|駐車場利用施設|駐車場型>関連施設{役割='利用施設'}>施設[2]>表記|〇〇市役所中央図書館|
|備考|駐車場型>備考|訪問部局で駐車場チケットに捺印をもらってください。|

### [製品型](#製品型)
#### 概要
各種の製品や商品などの情報を記述するための型です。製品型は製品や商品の仕様(どのようなものであるかについての情報)を記述し、実際に保有していたり利用している個別の製品・商品については[製品個品型](#製品個品型)を使って記述します。

この型の上位は[事物型](#事物型)です。また、その上位は[概念型](#概念型)です。この型では、事物型、概念型で用意されたプロパティも使われます。詳しくは[事物型](#事物型)、[概念型](#概念型)を参照してください。

#### 利用にあたってのヒント
- IDの記述
  - 製品・商品を識別するID(例えばJANコード)は、IDプロパティ([ID型](#id型))を使って記述します。
  - ID型でIDを書く場合、識別値プロパティ(xsd:string)にそのIDの値を記述します。また、そのID体系の名称(例えば"JANコード")を書くときは、体系プロパティの先の表記プロパティ(xsd:string)もしくは種別プロパティ(xsd:string)に記述します。詳しくは[ID型](#id型)を参照ください。
  - 複数のIDプロパティを使って、複数のIDを記述することができます。

- 自動認識用のIDの記述
  - バーコードやQRコードのような機械が読み取ることのできるIDを持っている場合、自動認識IDプロパティ(xsd:anyURI)の値としてそのIDの画像があるURLを記述します。

- 製造者の記述
  - 製造者の名称は製造者プロパティ(xsd:string)に記述します。
  - 製造者を特定できるID(例えば法人番号)は製造者IDプロパティ([ID型](#id型))を使って記述します。
  - ID型でIDを書く場合、識別値プロパティ(xsd:string)にそのIDの値を記述します。また、そのID体系の名称(例えば"法人番号")を書きたいときは、体系プロパティの先の表記プロパティ(xsd:string)もしくは種別プロパティ(xsd:string)に記述します。詳しくは[ID型](#id型)を参照ください。

- 販売業者の記述
  - 販売した店などの販売業者の名称は販売業者プロパティ(xsd:string)に記述します。
  - 販売業者を特定できるID(例えば法人番号)は販売業者IDプロパティ([ID型](#id型))を使って記述します。
  - ID型でIDを書く場合、識別値プロパティ(xsd:string)にそのIDの値を記述します。また、そのID体系の名称(例えば"法人番号")を書きたいときは、体系プロパティの先の表記プロパティ(xsd:string)もしくは種別プロパティ(xsd:string)に記述します。詳しくは[ID型](#id型)を参照ください。

- 入数の記述
  - 複数個の製品・商品がまとめられているパッケージとして販売されている製品・商品において、その個数(入数)を書くときは入数プロパティ([数量型](#数量型))を使います。
  - 数量型で製品・商品の個数(入数)を書くときは、数値プロパティ(xsd:decimal)にその数を記述します。また、製品・商品を数える単位("個"、"袋"など)を指定する場合は、単位表記プロパティ(xsd:string)に記述します。

- 形態の記述
  - 製品・商品がどのような形態であるか(例えば、ダンボール箱、缶、瓶)を書くときは、形態プロパティ(xsd:string)に記述します。

- 重量の記述
  - 製品・商品の重量を書く場合は、重量プロパティ([重量型](#重量型))を使います。
  - 重量型で重量を書く場合は、単位表記プロパティ(xsd:string)と、数値プロパティ(xsd:decimal)を使って記述します。
    - 例えば、重量60kgであれば数値プロパティに"60"、単位表記プロパティに"kg"と記述します。

- 幅、高さ、長さの記述
  - 製品の幅、高さ、長さはそれぞれ、幅プロパティ([長さ型](#長さ型))、高さプロパティ([長さ型](#長さ型))、長さプロパティ([長さ型](#長さ型))を使います。
  - 長さ型で長さを書く場合は、単位表記プロパティ(xsd:string)と、数値プロパティ(xsd:decimal)を使って記述します。
    - 例えば、長さ1000mmであれば数値プロパティに"1000"、単位表記プロパティに"mm"と記述します。

- サイズの記述
  - 幅、高さ、長さでは表現できないサイズを書きたいときや、幅、高さ、長さが一つのまとまった文字列で書きたいときは、サイズプロパティ(xsd:string)に記述します。

#### 例
|項目名|構造化項目名|値|
|:----|:----|:----|
|ID|*製品型>ID>識別値|EM-FOOD-12-001|
|製品名称|製品型>表記|保存用ビスケット60食入り(××製菓)|
|種類|製品型>種別|非常用ビスケット|
|種類コード|製品型>種別コード>識別値|EM-FOOD-12|
|バーコード|製品型>自動認識ID>|https://marumaru.city.lg.jp/hijo/id/EM-FOOD-12-001|
|購入価格|製品型>価格{種別='購入価格'}>金額{通貨='円'}>数値|10000|
|製造者|製品型>製造者|××製菓|
|製造者法人番号|製品型>製造者ID{種別='法人番号'}>識別値|5010005007126 |
|入数|製品型>入数{単位表記='個'}>数値|60|
|形態|製品型>形態|段ボール箱詰|
|重量|製品型>重量{単位表記='kg'}>数値|6.30|
|幅|製品型>幅{単位表記='mm'}>数値|365|
|高さ|製品型>高さ{単位表記='mm'}>数値|260|
|長さ|製品型>長さ{単位表記='mm'}>数値|190|
|原産国|製品型>原産国|日本|
|保存期間|製品型>記述{種別='保存期間'}>説明|5年|
|説明|製品型>説明|調理不要、容器不要、用具不要、食器不要|

### [製品個品型](#製品個品型)
#### 概要
所有、利用、管理などをしている製品を個別に記述するための型です。個別の製品ではなく、製品の仕様を記述するときは、[製品型](#製品型)を使います。

この型の上位は[製品型](#製品型)です。また、その上位は[事物型](#事物型)、[概念型](#概念型)です。この型では製品型、事物型、概念型で用意されたプロパティも使われます。詳しくは[製品型](#製品型)、[事物型](#事物型)、[概念型](#概念型)を参照してください。

#### 利用にあたってのヒント
- 製造日の記述
  - 製品の製造日を書くときは製造日プロパティ([日付型](#日付型))を使います。
  - 日付型で日付を書くときは、標準型日付プロパティ(xsd:date)や表記プロパティ(xsd:string)を使って一つの文字列として記述することもできますし、年号プロパティ(xsd:string)、年プロパティ(xsd:integer)、月プロパティ(xsd:integer)、日プロパティ(xsd:integer)等を使って分けて記述することもできます。詳しくは[日付型](#日付型)を参照ください。

- 消費期限、使用期限、賞味期限の記述
  - 消費期限、使用期限、賞味期限を書くときは、それぞれ、消費期限プロパティ([日付型](#日付型))、使用期限プロパティ([日付型](#日付型))、賞味期限プロパティ([日付型](#日付型))を使います。
  - 日付型で日付を書くときは、標準型日付プロパティ(xsd:date)や表記プロパティ(xsd:string)を使って一つの文字列として記述することもできますし、年号プロパティ(xsd:string)、年プロパティ(xsd:integer)、月プロパティ(xsd:integer)、日プロパティ(xsd:integer)等を使って分けて記述することもできます。詳しくは[日付型](#日付型)を参照ください。

- 所有者に関する記述
  - 製品を所有・保有する人や組織について書くときは、所有者プロパティ([実体型](#実体型))を使います。
  - 所有者プロパティの値型は実体型ですが、実際にはその継承で作られている[人型](#人型)や[組織型](#組織型)を型制約として指定して使います。
  - 所有者が個人の場合は、所有者プロパティの値型に人型を型制約として指定し、人型の各プロパティを使って所有者の情報を記述します。詳しくは[人型](#人型)を参照ください。
  - 所有者が法人などの組織の場合は、所有者プロパティの値型に組織型を型制約として指定し、組織型の各プロパティを使って所有者の情報を記述します。詳しくは[組織型](#組織型)を参照ください。

#### 例
|項目名|構造化項目名|値|
|:----|:----|:----|
|ID|*製品個品型>ID>識別値|4569951116179|
||製品個品型>ID>体系>表記|JANコード|
|製品名称|製品個品型>表記|保存用ビスケット60食入り(××製菓)|
|種類|製品個品型>種別|非常用ビスケット|
|種類コード|製品個品型>種別コード>識別値|EM-FOOD-12|
|バーコード|製品個品型>自動認識ID>|https://marumaru.city.lg.jp/hijo/id/EM-FOOD-12-001|
|価格|製品個品型>価格>金額{通貨='円'}>数値|10000|
|製造者|製品個品型>製造者|××製菓|
|製造者法人番号|製品個品型>製造者ID>識別値|5010005007126 |
||製品個品型>製造者ID>体系>表記|法人番号|
|入数|製品個品型>入数{単位表記='個'}>数値|60|
|形態|製品個品型>形態|段ボール箱詰|
|重量|製品個品型>重量{単位表記='kg'}>数値|6.30|
|幅|製品個品型>幅{単位表記='mm'}>数値|365|
|高さ|製品個品型>高さ{単位表記='mm'}>数値|260|
|長さ|製品個品型>長さ{単位表記='mm'}>数値|190|
|原産国|製品個品型>原産国|日本|
|保存期間|製品個品型>記述{種別='保存期間'}>説明|5年|
|説明|製品個品型>説明|調理不要、容器不要、用具不要、食器不要|
|製造日|製品個品型>製造日>標準型日付|2020-01-01|
|賞味期限|製品個品型>賞味期限>標準型日付|2024-01-01|
|シリアル番号|製品個品型>シリアル番号>識別値|123456789|
|保存状態|製品個品型>状態|非常備蓄庫保存|
|所有者|製品個品型>所有者{@組織型}>表記|○○市|
|連絡先|製品個品型>所有者{@組織型}>連絡先>表記|○○市総務部総務課|
|連絡先電話|製品個品型>所有者{@組織型}>連絡先>電話番号|0123-45-6789|

## 3.2 主にデータ項目の値型として部品的に用いるクラス用語
### [人数型](#人数型)
#### 概要
人数を記述するための型です。特に分類ごとの人数を記述する場合に使用します。

この型の上位は[概念型](#概念型)です。この型では、概念型で用意されたプロパティも使われます。詳しくは[概念型](#概念型)を参照してください。

#### 利用にあたってのヒント
- 分類及びカテゴリの記述
  - "未就学児"や"正社員"のように分類された人数を書くときは種別プロパティ(xsd:string)にその分類を記述します。
- 人数の記述
  - 対象の人数は人数プロパティ(xsd:nonNegativeInteger)を使って記述します。

#### 例
|項目名	|構造化項目名	|値|
|:----|:----|:----|
|種別|人数型>種別|正社員    |
|人数|人数型>人数| 3000 |

### [日付型](#日付型)
#### 概要
時間を伴わない日付を記述するための型です。時間も同時に記述する場合は、[日時型](#日時型)を使用します。

この型の上位は[概念型](#概念型)です。この型では、概念型で用意されたプロパティも使われます。詳しくは[概念型](#概念型)を参照してください。

#### 利用にあたってのヒント
- 日付の記述
  - 年月日を分割して書く方法と一つの文字列として書く方法があります。用途によって適切に使い分けるようにしてください。
  - 分割して書く場合は、年プロパティ(xsd:integer)、月プロパティ(xsd:integer)、日プロパティ(xsd:integer)を使用して記述します。標準型日付プロパティ(xsd:date)は使用しません。
    - 年プロパティ(xsd:integer)、月プロパティ(xsd:integer)のみ記述し、日プロパティ(xsd:integer)を省略した場合は月までを指定したことになります。
  - 一つの文字列として書く場合は、標準型日付プロパティ(xsd:date)あるいは表記プロパティ(xsd:string)を使って記述します。
    - 標準型日付プロパティは、"1999-10-10"のように「"西暦4桁"-"月2桁"-"日2桁"」といったxmlの標準的な書式(ISOの規定とほぼ同一)で記述します。この場合、年プロパティ(xsd:integer)、月プロパティ(xsd:integer)、日プロパティ(xsd:integer)は使用しません。
    - 表記プロパティは、標準型日付プロパティ以外の形式で日付を記述する場合に使用します。

- カレンダーの選択
  - 和暦など西暦以外のカレンダーで日付を書く場合は、年号プロパティ(xsd:string)に年号を記述したり、対象とするカレンダーのコードをカレンダープロパティ([コード型](#コード型))に記述したりします。ただし、西暦以外のカレンダーによる記述はあまり推奨されません。
  - 年号プロパティやカレンダープロパティを省略した場合は、西暦で記述します。

#### 例
|項目名	|構造化項目名	|値|
|:----|:----|:----|
|年    |日付型>年    | 2020|
|月    |日付型>月    | 9|
|日    |日付型>日    | 1 |

##### 一つの文字列として記述する例
|項目	|構造化項目名	|値|
|:----|:----|:----|
|日付|日付型>標準型日付|2020-09-01|

### [日時型](#日時型)
#### 概要
日付と時刻を合わせて記述するための型です。日付のみを記述する場合は、[日付型](#日付型)を使用します。

この型の上位は[概念型](#概念型)です。この型では、概念型で用意されたプロパティも使われます。詳しくは[概念型](#概念型)を参照してください。

#### 利用にあたってのヒント
- 日時の記述
  - 年月日時分秒を分割して書く方法と一つの文字列として書く方法があります。用途によって適切に使い分けるようにしてください。
  - 分割して書く場合は、年プロパティ(xsd:integer)、月プロパティ(xsd:integer)、日プロパティ(xsd:integer)、時プロパティ(xsd:integer)、分プロパティ(xsd:integer)、秒プロパティ(xsd:decimal)を使用して記述します。標準型日時プロパティ(xsd:dateTime)は使用しません。
    - 時プロパティ(xsd:integer)、分プロパティ(xsd:integer)のみ記述し、秒プロパティ(xsd:decimal)を省略した場合は分までを指定したことになります。
  - 一つの文字列として書く場合は、標準型日時プロパティ(xsd:dateTime)あるいは表記プロパティ(xsd:string)を使って記述します。
      - 標準型日時プロパティは、"1999-10-10T10:00:00"のように「"西暦4桁"-"月2桁"-"日2桁"T"時2桁":"分2桁":"秒2桁"」といったxmlの標準的な書式(ISOの規定とほぼ同一)で記述します。この場合、年プロパティ(xsd:integer)、月プロパティ(xsd:integer)、日プロパティ(xsd:integer)、時プロパティ(xsd:integer)、分プロパティ(xsd:integer)、秒プロパティ(xsd:decimal)は使用しません。
    - 表記プロパティは、標準型日時プロパティ以外の形式で日時を記述する場合に使用します。

- カレンダーの選択
  - 和暦など西暦以外のカレンダーで日付を書く場合は、年号プロパティ(xsd:string)に年号を記述したり、対象とするカレンダーのコードをカレンダープロパティ([コード型](#コード型))に記述したりします。ただし、西暦以外のカレンダーによる記述はあまり推奨されません。
  - 年号プロパティやカレンダープロパティを省略した場合は、西暦で記述します。

- タイムゾーンの記述
  - 年月日時分秒を分割して記述する場合で国際標準時からの時差を書きたい場合は、時間帯プロパティ(xsd:string)に時間帯を記述します。例えば日本時間であれば"日本標準時"のように記述します。
  - 一つの文字列として記述する場合は標準型日時プロパティ(xsd:dateTime)にxmlの標準的な書式で時間帯を記述します。

#### 例
|項目名	|構造化項目名	|値|
|:----|:----|:----|
|年    |日時型>年    | 2020|
|月    |日時型>月    | 9|
|日    |日時型>日    | 1 |
|時    |日時型>時    | 14 |
|分    |日時型>分    | 23 |
|秒    |日時型>秒    | 33 |
|時間帯  |日時型>時間帯  | 日本標準時|

##### 一つの文字列として記述する例
|項目	|構造化項目名	|値|
|:----|:----|:----|
|日時|日時型>標準型日時|2020-09-01T14:23:33+09:00|

### [組織関連型](#組織関連型)
#### 概要
組織同士の関係性を記述するための型です。類似する型に[関与型](#関与型)があります。組織関連型はグループ会社や子会社など資本関係や登記上の関係がある場合に使用し、それ以外の場合は関与型を使用します。

この型の上位は[概念型](#概念型)です。この型では、概念型で用意されたプロパティも使われます。詳しくは[概念型](#概念型)を参照してください。

#### 利用にあたってのヒント
- 関係性の記述
  - 組織の関係(例えば、"グループ会社"や"子会社"など)を役割プロパティ(xsd:string)に記述します。

#### 例

|項目名	|構造化項目名	|値|
|:----|:----|:----|
|役割|組織関連型>役割| 子会社 |
|組織名|組織関連型>組織>名称>表記| 〇〇システム株式会社  |

### [構成員型](#構成員型)
#### 概要
組織やグループの中で特別な役割を担う人物を記述するための型です。[業務組織型](#業務組織型)の代表者プロパティ([構成員型](#構成員型))などに使われています。

この型の上位は[概念型](#概念型)です。この型では、概念型で用意されたプロパティも使われます。詳しくは[概念型](#概念型)を参照してください。

#### 利用にあたってのヒント
- 役割の記述
  - グループの中で担っている役割は役割プロパティ(xsd:string)に記述します。表形式やcsv形式のデータにおいては、特定の項目に対して役割が固定の値となることが一般的です。(下記の表形式における表現を参照ください)

- 人物情報の記述
  - 対象となる人物の氏名や連絡先などは構成員プロパティ([人型](#人型))を使って記述します。詳しくは[人型](#人型)を参照ください。

#### 例
|項目名	|構造化項目名	|値|
|:----|:----|:----|
|役職 |構成員型>役割 | 代表取締役   |
|氏名|構成員型>構成員>氏名>姓名| 山田　花子  |

##### 表形式における表現
|法人名	|代表取締役|
|:----|:----|:----|
|〇〇株式会社|山田　花子|

この場合、下記の例のようにデータを構成する際に 法人>代表者>役割 に"代表取締役"が入るようにします。

##### データの構成例
|項目名	|構造化項目名	|値|
|:----|:----|:----|
|法人名|法人型>名称>表記|〇〇株式会社|
|代表取締役|法人型>代表者{役割='代表取締役'}>構成員>氏名>姓名| 山田　花子  |

### [関与型](#関与型)
#### 概要
人や組織、それらの活動等に関連する関係者を記述するための型です。組織の内外を問わず、特定の役割や役職をもつ人物や組織そのものを関係者として記述することができます。

この型の上位は[概念型](#概念型)です。この型では、概念型で用意されたプロパティも使われます。詳しくは[概念型](#概念型)を参照してください。

#### 利用にあたってのヒント
- 関係者の役割および役職の記述
  - 役割や役職などは、役割プロパティ(xsd:string)に記述します。
  - 役割の種類がコードとして用意されている場合は、役割コードプロパティ([コード型](#コード型))を使って記述します。詳しくは[コード型](#コード型)を参照ください。

- 関係者の情報の記述
  - 関係者の情報は、関与者プロパティ([実体型](#実体型))を使って記述します。
  - 関与者プロパティの値型は実体型ですが、実際にはその継承で作られている[人型](#人型)や[組織型](#組織型)を型制約として指定して使います。
  - 関係者が個人の場合は、関与者プロパティの値型に人型を型制約として指定し、人型の各プロパティを使って関係者の情報を記述します。詳しくは[人型](#人型)を参照ください。
  - 関係者が法人などの組織の場合は、関与者プロパティの値型に組織型を型制約として指定し、組織型の各プロパティを使って関係者の情報を記述します。詳しくは[組織型](#組織型)を参照ください。

#### 例
|項目名	|構造化項目名	|値|
|:----|:----|:----|
|役割   |関与型>役割   | 顧問弁護士 |
|関与者  |関与型>関与者{@人型}>氏名>姓名  | 山田　花子   |

##### 関与型の使用例
|項目名	|構造化項目名	|値|
|:----|:----|:----|
|法人名|法人型>名称>表記|〇〇株式会社  |
|顧問弁護士|法人型>関与{役割='顧問弁護士'}>関与者{@人型}>氏名>姓名|山田　花子 |

### [アクセス型](#アクセス型)
#### 概要
施設や建物へのアクセス情報について記述するための型です。施設型や建物型のアクセスプロパティの値型として使われ、単独の情報として使われることはないでしょう。

この型の上位は[概念型](#概念型)です。この型では、概念型で用意されたプロパティも使われます。詳しくは[概念型](#概念型)を参照してください。

#### 利用にあたってのヒント
アクセス型では主に3種類の方法でアクセス情報を記述することができます。
- 単純に文字列でアクセス情報を書くときは、備考プロパティ(xsd:string)に記述します。
- 始点と終点を指定してアクセス情報を書くときは、始点プロパティ([地物型](#地物型))と終点プロパティ([地物型](#地物型))を使って記述します。
- 複数のアクセス区間で構成されるアクセス情報を書くときは、アクセス区間プロパティ([アクセス区間型](#アクセス区間型))を使って記述します。

通常は1番目の方法で記述するので十分です。  
2番目以降の方法は構造的にアクセス情報を書くときに役に立ちます。駅やバス停を別途[施設型](#施設型)として記述しておくことで、そこにさらに駅やバス停の情報を記述することができます。さらに、一つのアクセス方法がいくつかの交通手段を組み合わせてできているときは、3番目の方法で構造的に書くことができます。鉄道、バス、車、徒歩など複数のアクセス方法があって、その組み合わせで、個別のアクセス手段を記述するときは、3番目の方法を使うと効率的に記述できます。

- アクセス手段の種別の記述
  - アクセス手段の種別(鉄道、バス、車、徒歩など)を書くときは、種別プロパティ(xsd:string)に記述します。

- アクセス手段の識別のためのIDの記述
  - 複数のアクセス方法が提供されているとき、その区別をするためにはIDプロパティ([ID型](#id型))を使います。
  - アクセス方法に"1", "2"などのIDを付与し、そのIDの値をIDプロパティの先の識別値プロパティ(xsd:string)に記述します。

- 文字列としてのアクセス手段の記述
  - アクセス手段を文字列で書くときは、備考プロパティ(xsd:string)に記述します。簡便に書くときはこのプロパティのみ使うので十分でしょう。

- 始点と終点の記述
  - アクセスの始点(終点)となる駅やバス停などを書くときは、始点プロパティ([地物型](#地物型))と終点プロパティ([地物型](#地物型))を使って記述します。
  - 始点プロパティと終点プロパティの値型は地物型ですが、実際にはその継承で作られている[建物型](#建物型)や[施設型](#施設型)を型制約として指定して使います。
    - 例えば、始点として駅を書くときは、始点プロパティの値型に施設型を型制約として指定し、施設型の表記プロパティ(xsd:string)を使って駅名を記述します。
  - 単に始点や終点を記述するのではなく、アクセス手段として始点や終点に付記すべき情報があるときは、始点備考プロパティ(xsd:string)と終点備考プロパティ(xsd:string)に記述します。例えば"駅バス乗り場3番"といった情報を記述します。

- 複数の区間からなるアクセスの記述
  - 一つのアクセス方法が複数の交通手段の組み合わせからできていて、その詳細を構造的に書くときには、アクセス区間プロパティ([アクセス区間型](#アクセス区間型))を使って記述します。詳しくは[アクセス区間型](#アクセス区間型)を参照ください。
  - アクセス区間プロパティを複数回使って、複数のアクセス区間を記述します。

- アクセス時間の記述
  - アクセスに要する時間を書くときは、時間プロパティ([数量型](#数量型))を使います。
  - 数量型で所要時間(時間や分)を書く場合は、数値プロパティ(xsd:decimal)と単位表記プロパティ(xsd:string)を使って記述します。
    - 例えば、15分であれば数値プロパティ(xsd:decimal)に"15"、単位表記プロパティ(xsd:string)に"分"と記述します。

#### 例
|項目名|構造化項目名|値|
|:----|:----|:----|
|アクセス方法|アクセス型>種別|公共交通機関|
|始点|アクセス型>始点{@施設型}>表記|○○駅|
|終点|アクセス型>終点{@施設型}>表記|××市役所前|
|アクセス方法|アクセス型>備考|○○駅から○×鉄道×○線で××駅下車。××駅西口バス停より○×バス×○線(丸03系統)で××市役所前下車。|
|アクセス時間|アクセス型>時間{単位表記='分'}>数値|15|

### [アクセス区間型](#アクセス区間型)
#### 概要
交通アクセスの個別の区間を記述するための型です。アクセス区間型は基本的にアクセス型のアクセス区間プロパティの値型としてのみ使われ、単独の情報として使われることはないでしょう。

この型の上位は[概念型](#概念型)です。この型では、概念型で用意されたプロパティも使われます。詳しくは[概念型](#概念型)を参照してください。

#### 利用にあたってのヒント
- アクセス手段の種別の記述
  - アクセス区間に対するアクセス手段の種別(鉄道、バス、徒歩など)を書くときには、種別プロパティ(xsd:string)に記述します。

- 始点と終点の記述
  - アクセスの始点(終点)となる駅やバス停などを書くときは、始点プロパティ([地物型](#地物型))と終点プロパティ([地物型](#地物型))を使って記述します。
  - 始点プロパティと終点プロパティの値型は地物型ですが、実際にはその継承で作られている[建物型](#建物型)や[施設型](#施設型)を型制約として指定して使います。
    - 例えば、始点として駅を書くときは、始点プロパティの値型に施設型を型制約として指定し、施設型の表記プロパティ(xsd:string)を使って駅名を記述します。
  - 単に始点や終点を記述するのではなく、アクセス手段として始点や終点に付記すべき情報があるときは、始点備考プロパティ(xsd:string)と終点備考プロパティ(xsd:string)を使って記述します。例えば"北口バス乗り場3番"といった情報を記述します。

- 路線の記述
  - アクセス手段が鉄道やバスなどの場合、その路線名を路線プロパティ(xsd:string)に記述します。

- アクセス時間の記述
  - アクセスに要する時間を書くときは、時間プロパティ([数量型](#数量型))を使います。
  - 数量型で所要時間(時間や分)を書く場合は、数値プロパティ(xsd:decimal)と単位表記プロパティ(xsd:string)を使って記述します。
    - 例えば、15分であれば数値プロパティ(xsd:decimal)に"15"、単位表記プロパティ(xsd:string)に"分"と記述します。

#### 例
|項目名|構造化項目名|値|
|:----|:----|:----|
|アクセス方法|アクセス区間型>種別|鉄道|
|始点|アクセス区間型>始点{@施設型}>表記|○○駅|
|路線|アクセス区間型>路線|○×鉄道×○線|
|終点|アクセス区間型>終点{@施設型}>表記|××駅|
|乗車時間|アクセス区間型>時間{単位表記='分'}>数値|10|

|項目名|構造化項目名|値|
|:----|:----|:----|
|アクセス方法|アクセス区間型>種別|バス|
|始点|アクセス区間型>始点{@施設型}>表記|××駅西口|
|路線|アクセス区間型>路線|○×バス×○線(丸03系統)|
|終点|アクセス区間型>終点{@施設型}>表記|××市役所前|
|乗車時間|アクセス区間型>時間{単位表記='分'}>数値|5|

### [参照型](#参照型)
#### 概要
写真などのマルチメディアやドキュメントなど、インターネット上の様々な関連リソースへの参照を記述するための型です。

この型の上位は[概念型](#概念型)です。この型では、概念型で用意されたプロパティも使われます。詳しくは[概念型](#概念型)を参照してください。

#### 利用にあたってのヒント
- 参照先の種類の記述
  - 参照先の種類(具体的な内容又はファイル形式)は種別プロパティ(xsd:string)に記述します。

- 参照先(URL)の記述
  - インターネット上のリソースへのURLは参照先プロパティ(xsd:anyURI)に記述します。

#### 例
|項目名	|構造化項目名	|値|
|:----|:----|:----|
|種別   |参照型>種別   | 説明動画 |
|参照先  |参照型>参照先>  | https://example.com/xxxx/yy.mpeg |

### [記述型](#記述型)
#### 概要
説明文を追加記述するための型です。説明プロパティ(xsd:string)を直接使用する場合と異なり、記述型では種別を指定することができるため、説明文の目的や対象などを明確にすることができます。

記述型のプロパティがある場合であっても、他に適したプロパティがある場合に記述型のプロパティを使用することは推奨されません。

この型の上位は[概念型](#概念型)です。この型では、概念型で用意されたプロパティも使われます。詳しくは[概念型](#概念型)を参照してください。

#### 利用にあたってのヒント
- 説明の目的や対象などの記述
  - "特記事項"や"注意事項"のように、説明の目的や対象などは種別プロパティ(xsd:string)に記述します。

- 説明内容の記述
  - 説明内容は説明プロパティ(xsd:string)に記述します。

#### 例
|項目	|構造化項目名	|値|
|:----|:----|:----|
|種別|記述型>種別|休館日に関する特記事項    |
|説明|記述型>説明|水曜日が祝日の場合は木曜日が休館となります。    |

### [状況型](#状況型)
#### 概要
設立や倒産など、組織などの活動状況や状態を記述するための型です。状況型では、組織の記述に付随して、時間的に変化する組織などの状態を記述するときに使います。

類似する型に[活動型](#活動型)と[イベント型](#イベント型)があります。活動型における活動とは、組織や人が主体的に行う出来事で、主体となる組織や人に関連づけて記述します。イベント型はある目的を持って場所や時間を決めて開催されるもので、関与する組織や人とは独立に記述します。

この型の上位は[概念型](#概念型)です。この型では、概念型で用意されたプロパティも使われます。詳しくは[概念型](#概念型)を参照してください。

#### 利用にあたってのヒント
- 状況の記述
  - 状況を端的に表現する名称を書くときは、名称プロパティ([名称型](#名称型))の先の表記プロパティ(xsd:string)に記述します。詳しくは[名称型](#名称型)を参照ください。
  - 状況に関する詳細な説明を書きたいときは、説明プロパティ(xsd:string)に記述します。

- 状況の変化に関わった人物や組織の記述
  - 状況の変化に関わった人物や組織を書きたいときは、関与プロパティ([関与型](#関与型))を使います。
  - 関与型には役割プロパティ(xsd:string)と関与者プロパティ([実体型](#実体型))があります。役割プロパティに関係の説明を記述し、関与者プロパティに関係する人物や組織を記述します。
    - 関与者プロパティの値型は実体型ですが、実際にはその継承で作られている[人型](#人型)や[組織型](#組織型)を型制約として指定して使います。
    - 詳しくは[関与型](#関与型)を参照ください。

#### 例
|項目名	|構造化項目名	|値|
|:----|:----|:----|
|名称 |状況型>名称>表記 |吸収合併 |
|発生日|状況型>発生日>標準型日時| 2020-09-01T09:00:00 |
|関与 |状況型>関与{役割='合併先企業'}>関与者{@組織型}>名称>表記 |〇〇株式会社 |
|説明 |状況型>説明 | 〇〇株式会社により吸収合併された|

### [期間型](#期間型)
#### 概要
繰り返しがなく開始日(開始日時)と終了日(終了日時)で指定できるスケジュールを記述するための型です。値型として[期間スケジュール型](#期間スケジュール型)が指定されているプロパティに対して、型制約として指定することができます。

この型の上位は[期間スケジュール型](#期間スケジュール型)です。この型では、期間スケジュール型、概念型で用意されたプロパティも使われます。詳しくは[期間スケジュール型](#期間スケジュール型)、[概念型](#概念型)を参照してください。

#### 利用にあたってのヒント
- 開始日時(終了日時)の記述
  - 開始日時または終了日時は、開始日時プロパティ([日時型](#日時型))あるいは終了日時プロパティ([日時型](#日時型))を使って記述します。
    - 日時型で日時を書くときは、標準型日時プロパティ(xsd:dateTime)や表記プロパティ(xsd:string)を使って一つの文字列として記述することもできますし、年号プロパティ(xsd:string)、年プロパティ(xsd:integer)、月プロパティ(xsd:integer)、日プロパティ(xsd:integer)、時プロパティ(xsd:string)、分プロパティ(xsd:string)、秒プロパティ(xsd:decimal)等を使って分けて記述することもできます。詳しくは[日時型](#日時型)を参照ください。

- 開始日(終了日)の記述
  - 開始日または終了日は、開始日時プロパティ([日時型](#日時型))あるいは終了日時プロパティ([日時型](#日時型))を使って記述します。
    - 日時型の標準型日時プロパティ(xsd:dateTime)を使う場合は、時分秒は00:00:00とします。
    - あるいは、年プロパティ(xsd:integer)、月プロパティ(xsd:integer)、日プロパティ(xsd:integer)を使って、年月日を個別に記述します。必ずしも、上述のすべてのプロパティに値を埋める必要はありません。
    - 詳しくは日時型を参照ください。

- 特記事項の記述
  - 特記事項を書くときは、説明プロパティ(xsd:string)に記述します。

#### 例
|項目名	|構造化項目名	|値|
|:----|:----|:----|
|開始日|期間型>開始日時>標準型日時| 2020-09-01T00:00:00 |
|終了日|期間型>終了日時>標準型日時| 2020-09-03T00:00:00 |
|説明  |期間型>説明  | 雨天の場合は中止となります。   |

|項目名	|構造化項目名	|値|
|:----|:----|:----|
|開始日(年)|期間型>開始日時>年 | 2020 |
|開始日(月)|期間型>開始日時>月 | 9 |
|開始日(日)|期間型>開始日時>日 | 1 |
|終了日(年)|期間型>終了日時>年 | 2020 |
|終了日(月)|期間型>終了日時>月 | 9 |
|終了日(日)|期間型>終了日時>日 | 3 |
|説明  |期間型>説明  | 雨天の場合は中止となります。   |

##### 期間型の使用例
|項目名	|構造化項目名	|値|
|:----|:----|:----|
|名称|イベント型>名称>表記| 〇〇地区ガス工事 |
|開始日|イベント型>期間{@期間型}>開始日時>標準型日時|2020-09-01T09:00:00 |
|終了日|イベント型>期間{@期間型}>終了日時>標準型日時|2020-09-01T17:00:00 |
|説明  |イベント型>期間{@期間型}>説明  | 工事中は〇〇地区〇〇道路で通行止めが随時発生します。  |

### [イベントスケジュール型](#イベントスケジュール型)
#### 概要
展示会や学園祭のように、ある期間に毎日開催されるイベントのスケジュールを記述するための型です。開催される日の開始時間と終了時間も指定できます。開催期間(または開催日)と開催期間中の開始終了時間の双方を指定します。値型として[期間スケジュール型](#期間スケジュール型)が指定されているプロパティに対して、型制約として指定することができます。

この型の上位は[期間スケジュール型](#期間スケジュール型)です。この型では、期間スケジュール型、概念型で用意されたプロパティも使われます。詳しくは[期間スケジュール型](#期間スケジュール型)、[概念型](#概念型)を参照してください。

#### 利用にあたってのヒント
- 開催期間の記述
  - 一日だけの開催の場合は、開催日を開催日プロパティ([日付型](#日付型))を使って記述します。
  - 複数日にわたって開催される場合は開始日プロパティ([日付型](#日付型))と終了日プロパティ([日付型](#日付型))を使用して期間を記述します。詳しくは[日付型](#日付型)を参照ください。

- 開始時間と終了時間の記述
  - 開始時間は開始時間プロパティ(xsd:time)に、終了時間は終了時間プロパティ(xsd:time)に記述します。

- 特記事項の記述
  - 最終日のみ早く終了するなどの特記事項は説明プロパティ(xsd:string)に記述します。

#### 例
|項目名	|構造化項目名	|値|
|:----|:----|:----|
|開催日 |イベントスケジュール型>開催日>標準型日付 | 2020-09-01 |
|開始時間|イベントスケジュール型>開始時間| 10:00:00 |
|終了時間|イベントスケジュール型>終了時間| 17:00:00 |
|説明  |イベントスケジュール型>説明  | 入場は16:30までとなります。 |

|項目名	|構造化項目名	|値|
|:----|:----|:----|
|開始日 |イベントスケジュール型>開始日>標準型日付 | 2020-09-01 |
|終了日 |イベントスケジュール型>終了日>標準型日付 | 2020-09-03 |
|開始時間|イベントスケジュール型>開始時間| 10:00:00 |
|終了時間|イベントスケジュール型>終了時間| 17:00:00 |
|説明  |イベントスケジュール型>説明  | 入場は16:30までとなります。 |

### [定期スケジュール型](#定期スケジュール型)
#### 概要
施設の営業時間のように開始時間と終了時間が決まった状態が一定期間にわたって継続するスケジュールを記述するための型です。期間内に毎日開催される場合ではなく、特定の曜日だけに開催するといったスケジュールも書くことができます。値型として[期間スケジュール型](#期間スケジュール型)が指定されているプロパティに対して、型制約として指定することができます。

この型の上位は[期間スケジュール型](#期間スケジュール型)です。この型では、期間スケジュール型、概念型で用意されたプロパティも使われます。詳しくは[期間スケジュール型](#期間スケジュール型)、[概念型](#概念型)を参照してください。

#### 利用にあたってのヒント
- 開始時間と終了時間の記述
  - 一日のうちでの開始する時間を開始時間プロパティ(xsd:time)に、終了する時間を終了時間プロパティ(xsd:time)に記述します。

- スケジュールが始まる年月日と終了する年月日の記述
  - スケジュールの始まりあるいは終わりが決まっている場合は、有効開始日時プロパティ([日時型](#日時型))あるいは有効終了日時プロパティ([日時型](#日時型))を使って記述します。詳しくは[日時型](#日時型)を参照ください。
  - これらのプロパティに値を入れない場合は、このスケジュールの始まりあるいは終わりは決まってないという意味になります。

- 開催パターンやその例外の記述
  - 毎日ではなく、特定の曜日のみ開催だったり特定の日には開催しないなどを書くときは、種別プロパティ(xsd:string)、開催期日プロパティ(xsd:string)および説明プロパティ(xsd:string)を使って記述します。
  - 一週間の中での開催周期が決まっている場合(例えば土日開催、月曜休館)は"週間"、一月の中での開催周期が決まっている場合は"月間"、一年の中での開催周期が決まっている場合は"年間"を種別プロパティに記述します。
  - 種別プロパティに指定した開催周期に沿った形で開催パターンを開催期日プロパティに記述します。
  - 開催パターンから外れる開催や不開催等の特記事項は説明プロパティに記述します。

#### 例
|項目名	|構造化項目名	|値|
|:----|:----|:----|
|開始時間  |定期スケジュール型>開始時間  | 10:00:00   |
|終了時間  |定期スケジュール型>終了時間  | 18:30:00   |
|オープン日 |定期スケジュール型>有効開始日時>標準日時 |2019-12-01T10:00:00 |
|クローズ日 |定期スケジュール型>有効終了日時>標準日時	|2020-03-15T18:30:00 |
|開催日 |定期スケジュール型{種別='週間'}>開催期日 |金土日、祝日 |
|特記事項 |定期スケジュール型>説明 |気温が一定以上の場合は休館することがあります。 |

### [範囲制約型](#範囲制約型)
#### 概要
イベント、サービス、統計データ等の条件において、条件となる範囲が特定の数値の範囲によって定義されていることを記述するための型です。値型として[制約型](#制約型)が指定されているプロパティに対して、型制約として指定することができます。

この型の上位は[制約型](#制約型)です。その上位は[概念型](#概念型)です。この型では、制約型、概念型で用意されたプロパティも使われます。詳しくは[制約型](#制約型)、[概念型](#概念型)を参照してください。

#### 利用にあたってのヒント
- 範囲判定の対象の記述
  - 範囲判定の対象となるプロパティを制約対象プロパティ(xsd:string)に構造化項目名で記述します。
  - 例えば、人の年齢を範囲判定の対象とする場合は"人型>年齢>数値"と記述します。
  - なお、制約対象プロパティの記述は、構造化項目名の構文による文字列の記述という特殊なケースとなります。

- 上限値の記述
  - ～以下のように指定した数値を含む値を書く場合は、上限値プロパティ([数量型](#数量型))の先の数値プロパティに記述します。
  - ～未満のように指定した数値を含まない値を書く場合は、境界を含まない上限値プロパティ([数量型](#数量型))の先の数値プロパティに記述します。

- 下限値の記述
  - ～以上のように指定した数値を含む値を書く場合は、下限値プロパティ([数量型](#数量型))の先の数値プロパティに記述します。
  - ～より大きいのように指定した数値を含まない値を書く場合は、境界を含まない下限値プロパティ([数量型](#数量型))の先の数値プロパティに記述します。

#### 例
|項目名	|構造化項目名	|値|
|:----|:----|:----|
|制約対象       |範囲制約型>制約対象       | 人型>年齢>数値 |
|上限値       |範囲制約型>境界を含まない上限値>数値       | 60 |
|下限値       |範囲制約型>下限値>数値       | 12 |

### [期間制約型](#期間制約型)
#### 概要
イベント、サービス、統計データ等の条件において、条件となる範囲が時間的な期間によって定義されていることを記述するための型です。値型として[制約型](#制約型)が指定されているプロパティに対して、型制約として指定することができます。

この型の上位は[制約型](#制約型)です。その上位は[概念型](#概念型)です。この型では、制約型、概念型で用意されたプロパティも使われます。詳しくは[制約型](#制約型)、[概念型](#概念型)を参照してください。

#### 利用にあたってのヒント
- 範囲判定の対象の記述
  - 範囲判定の対象となるプロパティを制約対象プロパティ(xsd:string)に構造化項目名で記述します。
    - 例えば、人の生年月日を範囲判定の対象とする場合は"人型>生年月日"と記述します。
  - なお、制約対象プロパティの記述は、構造化項目名の構文による文字列の記述という特殊なケースとなります。  

- 期間の記述
  - 条件とする期間は期間プロパティ([期間スケジュール型](#期間スケジュール型))を使って記述します。
  - 期間プロパティの値型は期間スケジュール型ですが、実際にはその継承で作られている[期間型](#期間型)や[イベントスケジュール型](#イベントスケジュール型)あるいは[定期スケジュール型](#定期スケジュール型)を型制約として指定して使います。
    - 期間制約型の場合、期間プロパティの値型には通常[期間型](#期間型)を型制約として指定し、開始日時と終了日時を期間型の開始日時プロパティ([日時型](#日時型))と終了日時プロパティ([日時型](#日時型))を使って記述します。
    - 詳しくは[日時型](#日時型)を参照ください。

#### 例
|項目名	|構造化項目名	|値|
|:----|:----|:----|-|
|制約対象 |期間制約型>制約対象   | 人型>生年月日 |
|開始|期間制約型>期間{@期間型}>開始日時>標準型日時| 2019-04-01T00:00:00 |
|終了|期間制約型>期間{@期間型}>終了日時>標準型日時| 2020-03-31T23:59:59 |

### [コード制約型](#コード制約型)
#### 概要
イベント、サービス、統計データ等の条件において、条件となる範囲が予めコードによって定義されていることを記述するための型です。値型として[制約型](#制約型)が指定されているプロパティに対して、型制約として指定することができます。

この型の上位は[制約型](#制約型)です。その上位は[概念型](#概念型)です。この型では、制約型、概念型で用意されたプロパティも使われます。詳しくは[制約型](#制約型)、[概念型](#概念型)を参照してください。

#### 利用にあたってのヒント
- 範囲判定の対象の記述
  - 範囲判定の対象となるプロパティを制約対象プロパティ(xsd:string)に構造化項目名で記述します。
    - 例えば、人の性別を識別する性別コードを範囲判定の対象とする場合は"人型>性別コード"と記述します。
  - なお、制約対象プロパティの記述は、構造化項目名の構文による文字列の記述という特殊なケースとなります。  

- 条件を表すコードの記述
  - 条件を表すコードを制約コードプロパティ([コード型](#コード型))を使って記述します。
    - 例えば、条件として性別コードが"2"(女)であるといった場合は、対象となるコードとその識別値等の情報をコード型を使って記述します。詳しくは[コード型](#コード型)を参照ください。
  - 条件を表すコードが複数ある場合は、制約コードプロパティを複数回使って記述します。

#### 例
|項目名	|構造化項目名	|値|
|:----|:----|:----|
|対象       |コード制約型>制約対象       | 人型>性別コード |
|制約コード|コード制約型>制約コード{種別='ISO 5218'}>識別値| 2 |

### [住所型](#住所型)
#### 概要
住所を記述するための型です。住所型が単独で使われることは稀で、人型や組織型等のプロパティの値として使われることが主です。住所の記述の方法については、行政基本情報データ連携モデル(https://cio.go.jp/guides)を参照してください。

この型の上位は[事物型](#事物型)です。また、その上位は[概念型](#概念型)です。この型では事物型、概念型で用意されたプロパティも使われます。詳しくは[事物型](#事物型)、[概念型](#概念型)を参照してください。

#### 利用にあたってのヒント
- 住所を一つの文字列として書くとき
  - 住所を一つの文字列として書くときは表記プロパティ(xsd:string)に記述します。この文字列に郵便番号は含まれるか、都道府県から始まる住所なのか市区町村から始まる住所なのかといった決まりはありません。このため、既存の住所記述をそのまま入れることができるという点では便利ですが、利用するときには注意が必要です。

- 住所を分かち書きで書くとき
  - 住所をその都道府県や市区町村などの部分部分に分けて記述することができます。
  - この時は、以下のプロパティを使います。
    - 郵便番号(xsd:string)、国(xsd:string)、都道府県(xsd:string)、市区町村(xsd:string)、区(xsd:string)、町名(xsd:string)、丁目(xsd:string)、番地補足(xsd:string)、番地(xsd:string)、号(xsd:string)、ビル名(xsd:string)、部屋番号(xsd:string)、方書(xsd:string)
  - 日本においては法令の違いや歴史的経緯から住所の表記には大きな多様性があります。しかし、本解説では住所の表記にあたっては、元々の住所の表記そのままの記述ではなく、平易で相互運用性が高い記述を推奨します。このため、町名-丁目-(番地補足)-番地-号という単一の分かち書きのみ用意し、また丁目、番地、号にはアラビア数字で書く事を推奨します。
  - 元々の住所の表記そのままの記述が必要な場合は、表記プロパティに記述します。
  - 都道府県の記述
    - 都道府県の名称は都道府県プロパティ(xsd:string)に記述します。
    - 都道府県コードを書くときは、都道府県コードプロパティ([コード型](#コード型))を使って記述します。
      - 都道府県コードプロパティの先の識別値プロパティ(xsd:string)に以下の2桁のコードを記述します。
      - 01:北海道, 02:青森県, 03:岩手県, 04:宮城県, 05:秋田県, 06:山形県, 07:福島県, 08:茨城県, 09:栃木県, 10:群馬県, 11:埼玉県, 12:千葉県, 13:東京都, 14:神奈川県, 15:新潟県, 16:富山県, 17:石川県, 18:福井県, 19:山梨県, 20:長野県, 21:岐阜県, 22:静岡県, 23:愛知県, 24:三重県, 25:滋賀県, 26:京都府, 27:大阪府, 28:兵庫県, 29:奈良県, 30:和歌山県, 31:鳥取県, 32:島根県, 33:岡山県, 34:広島県, 35:山口県, 36:徳島県, 37:香川県, 38:愛媛県, 39:高知県, 40:福岡県, 41:佐賀県, 42:長崎県, 43:熊本県, 44:大分県, 45:宮崎県, 46:鹿児島県, 47:沖縄県
    - 国内の住所であれば都道府県プロパティあるいは都道府県コードプロパティが記述されていることが期待されます。
  - 市区町村と区(行政区)の記述
    - 市、東京都の特別区、町、村の名称は市区町村プロパティ(xsd:string)に記述します。市区町村プロパティは必ず記述されていることが期待されます。
    - 政令指定都市の区(行政区)の名称は区プロパティ(xsd:string)に記述します。区プロパティは政令指定都市のみで使われます。
    - どちらのプロパティでも「○○市」「××区」のように市や区もしくは町村までを記述します。
  - 町名の記述
    - 町名や字の名称(市区町村・行政区の後、丁目あるいは番地より前の部分の地名)は町名プロパティ(xsd:string)に記述します。
    - 「○○町」、「字××」といった地名の場合、「町」や「字」まで含めて記述します。
    - 「大字××字○◯」「〇〇町△△」「北〇条東」といった複合的な地名であっても、一つの文字列として町名プロパティに記述します。
  - 丁目の記述
    - 丁目が存在する住所のときには、丁目プロパティ(xsd:string)に記述します。丁目がない住所では使いません。
    - 丁目の前の文字(「◯丁目」の「◯」)は丁目プロパティを使ってアラビア数字(「1」「2」等)で記述します。住所表記において、この部分は漢数字(「一」「二」等)であったり、アラビア数字(「1」「2」等)であったりします。漢数字かアラビア数字かは法令(地方自治法第260条等)で決まっている場合がありますが、本解説では法令や慣例に関わらず、アラビア数字を記述することを推奨します。
  - 街区符号と番地の記述
    - 住居表示の街区符号(「◯◯町××丁目12」の「12」)あるいは番地の値(「1234番地」の「1234」)は、番地プロパティ(xsd:string)を使ってアラビア数字で記述します。
  - 番地に付随する記述
    - 番地の記述の一部として現れる番地の前に使われる「東」「甲」などの文字は番地補足プロパティ(xsd:string)に記述します。
  - 番地の枝番と号の記述
    - 住居表示の住居番号(「◯◯町××丁目12番3号」の「3」)あるいは番地の枝番(「1234番地5」の「5」)は、号プロパティ(xsd:string)を使ってアラビア数字で記述します。
  - ビル名の記述
    - 住所に含まれるビル名等は、ビル名プロパティ(xsd:string)に記述します。
  - ビル番号の記述
    - 「□□団地◯◯号棟」や「□□ビル◯◯」など同一の名称のビルが複数あって番号等で区別するときの番号等は、ビル番号プロパティ(xsd:string)を使ってアラビア数字やアルファベットなどの組み合わせで記述します。
  - 階数や部屋番号の記述
    - ◯◯階や◯◯号室といったビルや施設の中の区分や区域を示す文字列は部屋番号プロパティ(xsd:string)に記述します。
  - 方書や社名や部署名など住所に付属する記述
    - 「◯◯方」「◯◯会社内」等、住所に付加する方書は方書プロパティ(xsd:string)に記述します。

- 一つの文字列としての住所記述と分かち書き方式による住所記述の使い分け
  - 表記プロパティを使った一つの文字列としての住所記述と、分かち書き方式の住所記述(都道府県、市区町村などに分けた住所記述)は、どちらか一方だけで住所を記述することもできますし、両方の方法で記述することもできます。
  - 分かち書き方式は利用する側からみれば便利ですが、データ作成には労力を要します。バランスを考えて決める必要があります。
  - なお、住所全てを分かち書き方式で記述するのではなく、必要な部分(プロパティ)だけ記述するという方法もあります。
    - 例えば、郵便番号プロパティと都道府県プロパティには値を入れるが、市区町村プロパティ以下は使わないという方法もありえます。ただし、その場合でも使うと決めたプロパティ(例えば都道府県プロパティと郵便番号プロパティ)は必ず値を記述するようにデータを作るべきです。

#### 例
|項目名|構造化項目名|値|
|:----|:----|:----|
|表記|住所型>表記|〒113-6591 東京都文京区本駒込2-28-8  文京グリーンコート センターオフィス|
|郵便番号|住所型>郵便番号|113-6591|
|国|住所型>国|日本|
|都道府県|住所型>都道府県|東京都|
|区|住所型>区|文京区|
|町名|住所型>町名|本駒込|
|丁目|住所型>丁目|2|
|番地|住所型>番地|28|
|号|住所型>号|8|
|ビル名|住所型>ビル名|文京グリーンコート センターオフィス|
|部屋番号|住所型>部屋番号|13階|

|項目名|構造化項目名|値|
|:----|:----|:----|
|表記|住所型>表記|〒100-2101 東京都小笠原村父島字西町|
|郵便番号|住所型>郵便番号|100-2101|
|国|住所型>国|日本|
|都道府県|住所型>都道府県|東京都|
|市区町村|住所型>市区町村|小笠原村|
|町名|住所型>町名|父島字西町|

### [連絡先型](#連絡先型)
#### 概要
施設、設備やイベントなどの記述をする際に、連絡先の情報を記述するための型です。施設型、設備型、イベント型等にある連絡先プロパティの値型として使われています。一つの連絡先には名称から住所、電話番号等の複数の項目があることがありますが、この型を使うことで、これらの項目が一まとまりであることを示すことができます。このため、施設やイベントに連絡先が複数ある時に混同することがありません。

この型の上位は[事物型](#事物型)です。また、その上位は[概念型](#概念型)です。この型では、事物型、概念型で用意されたプロパティも使われます。詳しくは[事物型](#事物型)、[概念型](#概念型)を参照してください。

#### 利用にあたってのヒント
- 種別に関する記述
  - 連絡先に種別があるときは、種別プロパティ(xsd:string)にその種別を記述します。
  - 連絡先としての種別を記述することで、連絡先が複数ある時、連絡先の違いを示すことができます。
    - 例えば、ある建物に昼間と夜間で異なる連絡先がある時、種別プロパティには"昼間"、"夜間"などと明示することができます。

- 名称の記述
  - 簡単に文字列として連絡先の名称を書きたいときは、表記プロパティ(xsd:string)に記述します。
  - 名称にカナ表記やローマ字表記もある場合は、名称プロパティ([名称型](#名称型))を使います。
  - 名称型でカナ表記やローマ字表記を書くときは、カナ表記プロパティ(xsd:string)やローマ字表記プロパティ(xsd:string)に記述します。詳しくは[名称型](#名称型)を参照ください。

- 組織の記述
  - 連絡先が法人などの組織によって運営されていることを書くには、組織プロパティ([組織型](#組織型))を使います。
  - 簡単に組織の名称を記述するのであれば、組織プロパティの先の表記プロパティ(xsd:string)に記述します。
  - より詳細な組織の情報を書きたいときは、組織プロパティの先の各種プロパティを使って記述します。詳しくは[組織型](#組織型)を参照ください。

- 担当者の記述
  - 連絡先の担当者を書くときは、担当者名プロパティ([氏名型](#氏名型))を使います。
  - 担当者名を簡単に書くときは、担当者名プロパティの先の表記プロパティ(xsd:string)に記述します。
  - 担当者名を漢字表記、カナ表記、ローマ字表記に分けて書くときは、それぞれ、担当者プロパティの先の姓名プロパティ(xsd:string)、姓名カナ表記プロパティ(xsd:string)、姓名ローマ字表記プロパティ(xsd:string)に記述します。

- 担当者の役職の記述
  - 担当者の組織の中での役職(例えば"広報担当"など)を書くときは、担当者役職(xsd:string)に記述します。

- 住所の記述
  - 連絡先の住所は住所プロパティ([住所型](#住所型))を使います。
  - 住所型で住所を書くときは、表記プロパティ(xsd:string)を使って、一つの文字列として記述することもできますし、都道府県プロパティ(xsd:string)、市区町村プロパティ(xsd:string)等を使って、分けて記述することもできます。詳しくは[住所型](#住所型)を参照ください。

#### 例
|項目名|構造化項目名|値|
|:----|:----|:----|
|連絡先名称|連絡先型>表記|××祭り連絡担当|
|連絡先名称(英語)|連絡先型>名称>ローマ字表記|Contact for Festival xx|
|連絡先組織|連絡先型>組織>表記|○○市役所|
|担当者|連絡先型>担当者名>表記|井美太郎|
|担当者(英語)|連絡先型>担当者名>姓名ローマ字表記|Taro Imi|
|担当者役職|連絡先型>担当者役職|広報課地域担当|
|メール|連絡先型>Eメールアドレス|event@marumaru.city.lg.jp|
|住所|連絡先型>住所>表記|〇〇市本町1-1-1|
|電話番号|連絡先型>電話番号|0123-45-6789|
|対応言語|連絡先型>対応言語|英語可|

### [活動型](#活動型)
#### 概要
組織や人の活動を記述するための型です。活動とは組織や人が主体的に行う出来事です。活動の記述においては、活動の主体である組織や人が何を行なったかということを記述します。類似する型として、[イベント型](#イベント型)と[状況型](#状況型)があります。イベント型はある目的を持って場所や時間を決めて開催されるもので、関与する組織や人とは独立に記述します。状況型は組織等に付随して、組織等の時間的に変化する状態を記述します。

この型の上位は[事物型](#事物型)です。その上位は[概念型](#概念型)です。この型では、事物型、概念型で用意されたプロパティも使われます。詳しくは[事物型](#事物型)、[概念型](#概念型)を参照してください。

#### 利用にあたってのヒント
- 活動内容の記述
  - 活動項目を一覧表示する場合などに使用する活動の名称を書くときは、名称プロパティ([名称型](#名称型))の先の表記プロパティ(xsd:string)に記述します。詳しくは[名称型](#名称型)を参照ください。
  - 活動内容に詳細な説明を書きたいとき、説明プロパティ(xsd:string)に記述します。

- 活動に関わった人物や組織の記述
  - 対象となる活動に関わった人物や組織を書きたいときは、関与プロパティ([関与型](#関与型))を使います。
  - 関与型には役割プロパティ(xsd:string)と関与者プロパティ([実体型](#実体型))があります。役割プロパティに関係の説明を記述し、関与者プロパティに関係する人や組織を記述します。
    - 関与者プロパティの値型は実体型ですが、実際にはその継承で作られている[人型](#人型)や[組織型](#組織型)を型制約として指定して使います。
    - 詳しくは[関与型](#関与型)を参照ください。

#### 例
|項目名	|構造化項目名	|値|
|:----|:----|:----|
|名称|活動型>名称>表記| 株式の上場 |
|日時|活動型>日時>標準型日時| 2019-09-01T09:00:00  |

### [対象型](#対象型)
#### 概要
イベント、サービス、統計データ等において、対象となる事物や人の範囲を限定することがあります。このときの条件をつける対象を記述するための型です。実際にはこの型は制約型を使って制約を書くときに便宜的に用意するもので、この型の制約プロパティ(制約型)だけが重要です。

この型の上位は[事物型](#事物型)です。その上位は[概念型](#概念型)です。この型では、[事物型](#事物型)、[概念型](#概念型)で用意されたプロパティも使われます。詳しくは[事物型](#事物型)、[概念型](#概念型)を参照してください。

#### 利用にあたってのヒント
- 対象の範囲の記述
  - 対象の範囲は制約プロパティ([制約型](#制約型))を使って記述します。
  - 制約プロパティの値型は制約型ですが、実際はその継承で作られている[コード制約型](#コード制約型)、[範囲制約型](#範囲制約型)、[期間制約型](#期間制約型)を型制約として指定して使います。
  - 例えば、対象の範囲が人の年齢の場合は、制約プロパティの値型に範囲制約型を型制約として指定し、範囲制約型の各プロパティを使って範囲判定の対象やその年齢範囲を記述します。詳しくは[制約型](#制約型)を参照ください。

#### 例
|項目名	|構造化項目名	|値|
|:----|:----|:----|
|最高対象年齢  |対象型>制約{@範囲制約型}{制約対象='人型>年齢>数値'}>上限値{単位表記='歳'}>数値 | 12 |
|最低対象年齢  |対象型>制約{@範囲制約型}{制約対象='人型>年齢>数値'}>下限値{単位表記='歳'}>数値 | 0  |

### [電話番号型](#電話番号型)
#### 概要
電話番号を記述するための型です。電話番号型は特殊な型でそれ自体が文字列として扱われます。

#### 利用にあたってのヒント
- 電話番号
  - 電話番号は必要に応じて"()"または"-"で区切るか数字のみで記述します。

#### 例
|項目	|構造化項目名	|値|
|:----|:----|:----|
|氏名|人型>氏名>姓名|山田　花子    |
|電話番号|人型>連絡先>電話番号|090-0000-0000 |

### [長さ型](#長さ型)
解説省略
### [重量型](#重量型)
解説省略
### [面積型](#面積型)
解説省略
### [容量型](#容量型)
解説省略
### [数量型](#数量型)
解説省略
### [金額型](#金額型)
解説省略
### [施設関連型](#施設関連型)
解説省略
### [名称型](#名称型)
解説省略
### [氏名型](#氏名型)
解説省略
### [価格型](#価格型)
解説省略
### [座標型](#座標型)
解説省略

## 3.3 IDやコードを表現するために用いるクラス用語
### [ID型](#id型)
#### 概要
法人番号や製品のシリアル番号といったIDの値(識別値)を記述するための型です。

データの中ではIDへの参照を記述します。HTMLやLinked Open Data(LOD)では、IDを示すURIを記述します。また、データを表形式やcsv形式などで入力または表示する際には識別値のみを使用するのが一般的です。

ID型に似たものとして[コード型](#コード型)があります。[コード型](#コード型)が一つ一つの値に意味がある場合に使用されるのに対し、ID型は製品のシリアル番号や法人の番号など、同種のものを識別するために使用します。

この型の上位は[概念型](#概念型)です。この型では、概念型で用意されたプロパティも使われます。詳しくは[概念型](#概念型)を参照してください。

#### 利用にあたってのヒント
- IDの値(識別値)の記述
  - IDの値(識別値)(たとえば製品のシリアル番号)は識別値プロパティ(xsd:string)に記述します。
  - 数字が並んだものである場合でも文字列として記述します。したがって、"03" と "3" は異なる値として扱われる点に注意してください。

- ID体系の記述
  - IDの記述においてはIDの値(識別値)だけでなく、IDを管理する仕組み(ID体系)を指定することが必要です。値だけでは、なんのIDであるかがわかりません。
  - ID体系を簡便に書くときは、種別プロパティ(xsd:string)を使って記述します。ID体系を固定値制約で指定するときは、ID体系の名称を種別プロパティを使って記述するのがよいでしょう。
  - ID体系を正確に書くときは、体系プロパティ([ID体系型](#id体系型))を使います。
    - 体系プロパティの先の表記プロパティ(xsd:string)にID体系の名称を記述し、さらに発行者プロパティ([実体型](#実体型))に発行者を記述することができます。詳しくは[ID体系型](#id体系型)を参照ください。

#### 例
|項目名	|構造化項目名	|値|
|:----|:----|:----|
|法人番号	|ID型{種別='法人番号'}>識別値 |5010005007126|

|項目名	|構造化項目名	|値|
|:----|:----|:----|
|ID体系の名称 |ID型>体系>表記 |法人番号 |
|ID体系の発行者	|ID型>体系>発行者{@組織型}>名称>表記	|国税庁 |
|識別値|ID型>識別値|5010005007126 |

##### IDの使用例
|項目名	|構造化項目名	|値|
|:----|:----|:----|
|法人名|法人型>名称>表記|〇〇株式会社  |
|法人番号|法人型>ID{種別='法人番号')>識別値 |5010005007126 |

### [コード型](#コード型)
#### 概要
コードの値を記述するための型です。例えば、ISO 5218 に規定されている性別コードであれば、2 = female(女)という一つの値を表現するために使用されます。一方、ISO 5218 に規定される複数の値(0 = not known(不明)、1 = male(男)、2 = female(女)、9 = not applicable(適用不能))の集合を表現するには[コードリスト型](#コードリスト型)を使用します。

性別のような一般的なものについては、可能な限りあらかじめ定義されているコード型を使用します。データの中ではコードへの参照を記述します。HTMLやLinked Open Data (LOD)であれば、コードを示すURIを記述します。また、データを表形式やcsv形式などで入力または表示する際には識別値のみを使用するのが一般的です。

データに固有のコードを作成する場合には、コードリストおよびコードを作成する必要があります。詳しくは[コードリスト型](#コードリスト型)を参照ください。

コード型に似たものとして[ID型](#id型)があります。[ID型](#id型)が製品のシリアル番号や法人の番号など同種のものを識別するために使用されるのに対し、コード型は一つ一つの値に意味がある場合に使用します。

この型の上位は[概念型](#概念型)です。この型では、概念型で用意されたプロパティも使われます。詳しくは[概念型](#概念型)を参照してください。

#### 利用にあたってのヒント
- コードの値の記述
  - コードの値(上記の例で女であれば"2")は識別値プロパティ(xsd:string)に記述します。
  - 数字が並んだものである場合でも文字列として記述します。したがって、"03" と "3" は異なる値として扱われる点に注意してください。

- コードの説明やラベルの記述
  - コードが表すものの説明やラベル(上記の例で女あれば"female")は表記プロパティ(xsd:string)に記述します。
  - エラーコードのように説明が長文になる場合は表記プロパティ(xsd:string)に短い表題を記述し、説明プロパティ(xsd:string)に説明を記述します。

- コードが属するコードリストの記述
  - コードが属するコードリスト(コードの集合)を正確に書くときは、コード種別プロパティ([コードリスト型](#コードリスト型))を使って記述します。詳しくは[コードリスト型](#コードリスト型)を参照ください。
  - コードが属するコードリストを簡便に書くときは、種別プロパティ(xsd:string)を使って記述することもできます。コードリストを固定値制約で指定するときは、コードリストの名称を種別プロパティを使って記述するのがよいでしょう。

- 階層化されたコードの記述
  - 大分類・中分類のように階層化されたコードの場合は、階層の上位のコードや下位のコードをそれぞれ、上位コードプロパティ([コード型](#コード型))や下位コードプロパティ([コード型](#コード型))として記述します。
  - 上位コードや下位コードが複数ある場合は、これらのプロパティを複数回使うことができます。
  - 上位コードや下位コードは同じコードリスト内のコードである必要はありません。

- コードに関連するものへの参照の記述
  - コードに関連するものへのリンクを書きたいときは、参照プロパティ([参照型](#参照型))を使って記述します。
  - 参照先がインターネット上のデータやサイトの場合には、参照プロパティの先の参照先プロパティ(xsd:anyURI)にリンクを記述します。

#### 例
|項目名	|構造化項目名	|値|
|:----|:----|:----|
|識別値 |コード型>識別値  |2    |
|表記   |コード型>表記   |女 |
|コードリスト名称	|コード型>コード種別>表記 |ISO 5218 |
|コードリスト説明	|コード型>コード種別>説明 |ISO/IEC 5218:2004 Information technology — Codes for the representation of human sexes |
|コードリスト発行者 |コード型>コード種別>発行者{@組織型}>表記	|International Organization for Standardization |
|コードリスト参照先 |コード型>コード種別>参照>参照先> |https://www.iso.org/standard/36266.html |

##### コードの使用例
|項目名	|構造化項目名	|値|
|:----|:----|:----|
|氏名|人型>氏名>姓名|山田　花子    |
|性別|人型>性別コード{種別='ISO 5218'}>識別値 |2 |

##### 表形式における表現
|氏名	|性別|
|:----|:----|:----|
|山田　花子    |2|

### [単位コード型](#単位コード型)
#### 概要
数量の単位について記述するための型です。主に、[数量型](#数量型)、[容量型](#容量型)、[面積型](#面積型)、[重量型](#重量型)、[長さ型](#長さ型)の単位プロパティの値型として使われ、単独の情報として使われることはありません。一般的なデータを作成する場合には、単位コード型を使ったデータを作成することはありません。データをcsv形式などで入力または表示する際にはコードの値(識別値)のみを使用します。

この型の上位は[コード型](#コード型)です。その上位は[概念型](#概念型)です。この型では、コード型、概念型で用意されたプロパティも使われます。詳しくは[コード型](#コード型)、[概念型](#概念型)を参照してください。

#### 利用にあたってのヒント
- コードの値(識別値)の記述
  - コードの値(例えば"km")は識別値プロパティ(xsd:string)に記述します。

- コードの説明やラベルの記述
  - コードが表すものの説明やラベル(例えば"キログラム")は表記プロパティ(xsd:string)に記述します。

- コードが属するコードリストの記述
  - コードが属するコードリスト(コードの集合)については、コード種別プロパティ([コードリスト型](#コードリスト型))を使って記述します。詳しくは[コードリスト型](#コードリスト型)を参照ください。

- 量種別の記述
  - 長さを表す単位(例えば"m")であれば"長さ"、重量を表す単位(例えば"kg")であれば"重量"というような量の種別については量種別プロパティ(xsd:string)に記述します。

- 乗数の記述
  - 基準となる単位(例えば、SI単位系であれば m(メートル)、kg(キログラム)、など)に対する乗数は乗数プロパティ(xsd:double)に記述します。
  - 例えば、km(キロメートル)の場合は、m(メートル)の1000倍となるため、乗数プロパティ(xsd:double)の値には1000.0と記述します。

#### 例
|項目名	|構造化項目名	|値|
|:----|:----|:----|
|コード種別|単位コード型>コード種別>表記|SI単位系 |
|識別値  |単位コード型>識別値  |km    |
|表記   |単位コード型>表記   |キロメートル|
|量種別|単位コード型>量種別|長さ    |
|乗数 |単位コード型>乗数 |1000.0    |

##### 単位コードの使用例
|項目名	|構造化項目名	|値|
|:----|:----|:----|
|製品|製品型>名称>表記|〇〇金具|
|重量|製品型>重量>数値|20 |
|重量単位|製品型>重量>単位{表記='SI単位系'}>識別値 |g |

##### 表形式における表現
|製品名	|重量|重量単位|
|:----|:----|:----|
|〇〇金具|20|g|

### [ID体系型](#id体系型)
#### 概要
IDの集合を記述するための型です。例えば、法人番号という集合を表現するために使用されます。一方、各法人番号に対しては[ID型](#id型)が使用されます。

法人番号のような一般的なものについては、可能な限りあらかじめ定義されているID体系型を使用します。データの中ではIDを直接に参照するため、ID体系の直接の参照は記述されません。例えば、Linked Open Data (LOD)でデータを記述する場合、個別のIDは個別のIDを指し示すURIによって表現します。ただし、そのURIだけでは、そのURIがどのID体系(IDの集合)の要素のIDであるのかわからないため、そのURIからID体系を示すURIへの関係(ID体系型のプロパティ)をつけて表現します。

データを表形式やcsv形式などで入力または表示する際にはIDを指し示す値(文字列や数値列)を使い、入力者がどのような種類のIDを記述すべきかをマニュアル等に記述するのが一般的です。この場合も、データだけを見ていると、そのIDがどのID体系の要素としてのIDなのかわかりません。IMIではこのような曖昧性を排除するため、IDを利用するときは、そのIDが基づいているID体系をデータの中で参照あるいは記述することを推奨します。ID体系の記述はこのために必要となります。

法人番号のようにすでに定義されているID体系であれば、それを参照するだけでよいのですが、データに固有のID体系の場合は、このID体系型を用いて、そのデータ固有のID体系を定義する必要があります。

この型の上位は[事物型](#事物型)です。その上位は[概念型](#概念型)です。この型では、事物型、概念型で用意されたプロパティも使われます。詳しくは[事物型](#事物型)、[概念型](#概念型)を参照してください。

#### 利用にあたってのヒント
- ID体系の名称
  - ID体系には名称を付けることが推奨されています。
  - ID体系の名称は、名称プロパティ([名称型](#名称型))の先の表記プロパティ(xsd:string)に記述します。詳しくは[名称型](#名称型)を参照ください。

- 管理上の情報
  - ID体系を管理している機関や個人を書くときは、発行者プロパティ([実体型](#実体型))を使って記述します。
  - 発行者プロパティの値型は実体型ですが、実際にはその継承で作られている[人型](#人型)や[組織型](#組織型)を型制約として指定して使います。詳しくは[人型](#人型)、[組織型](#組織型)を参照ください。
  - ID体系にバージョンがある場合は、バージョンプロパティ(xsd:string)に記述します。

#### 例
|項目名	|構造化項目名	|値|
|:----|:----|:----|
|名称   |ID体系型>名称>表記   |〇〇シリアル番号 |
|発行者  |ID体系型>発行者{@組織型}>名称>表記  |xxx社  |
|バージョン|ID体系型>バージョン| 1.0   |

### [コードリスト型](#コードリスト型)
#### 概要
コードの集合を記述するための型です。例えば、ISO 5218 に規定される複数の値(0 = not known(不明)、1 = male(男)、2 = female(女)、9 = not applicable(適用不能))の集合を表現するために使用されます。一方、2 = female(女)のような一つの値を表現する際には[コード型](#コード型)を使用します。

性別コードのような一般的なものについては、可能な限りあらかじめ定義されているコードリスト型を使用します。データの中ではコードから参照されるためコードリストの直接の参照は記述されません。例えば、Linked Open Data (LOD)でデータを記述する場合、個別のコードは個別のコードを指し示すURIによって表現します。ただし、そのURIだけでは、そのURIがどのコードリストの要素のコードであるのかわからないため、そのURIからコードリストを示すURIへの関係(コードリスト型のプロパティ)をつけて表現します。

データを表形式やcsv形式などで入力または表示する際にはコードを指し示す値(文字列や数値列)を使い、入力者がどのような種類のコードを記述すべきかをマニュアル等に記述するのが一般的です。この場合も、データだけを見ていると、そのコードがどのコードリストの要素としてのコードなのかわかりません。IMIではこのような曖昧性を排除するため、コードを利用するときは、そのコードが基づいているコードリストをデータの中に参照あるいは記述することを推奨します。コードリストの記述はこのために必要となります。

性別コードのようにすでに定義されているコードリストであれば、それを参照するだけでよいのですが、データに固有のコードリストの場合は、このコードリスト型を用いて、そのデータ固有のコードリストを定義する必要があります。

この型の上位は[事物型](#事物型)です。その上位は[概念型](#概念型)です。この型では、事物型、概念型で用意されたプロパティも使われます。詳しくは[事物型](#事物型)、[概念型](#概念型)を参照してください。

#### 利用にあたってのヒント
- コードリストの名称の記述
  - コードリストには名称を付けることが推奨されています。
  - コードリストの名称は、名称プロパティ([名称型](#名称型))の先の表記プロパティ(xsd:string)に記述します。詳しくは[名称型](#名称型)を参照ください。

- 管理上の情報の記述
  - コードリストを定めている機関や個人を書くときは、発行者プロパティ([実体型](#実体型))を使って記述します。
  - 発行者プロパティの値型は実体型ですが、実際にはその継承で作られている[人型](#人型)や[組織型](#組織型)を型制約として指定して使います。詳しくは[人型](#人型)、[組織型](#組織型)を参照ください。
  - コードリストにバージョンがある場合は、バージョンプロパティ(xsd:string)に記述します。

#### 例
|項目名	|構造化項目名	|値|
|:----|:----|:----|
|名称   |コードリスト型>名称>表記   |〇〇エラーコード |
|発行者  |コードリスト型>発行者{@組織型}>名称>表記  |xxx社  |
|バージョン|コードリスト型>バージョン| 1.0   |

## 3.4 語彙定義の基礎として用いる抽象的なクラス用語
### [概念型](#概念型)
#### 概要
コア語彙の全ての型に共通する情報を記述するために用意された抽象的な型です。概念型はコア語彙における全ての型の上位の型(共通の親に当たる型)としての役割を持ち、この型を直接使って何かの情報を記述することはありません。  

この型では、下位の型で共通に使われるプロパティが用意されています。

#### 利用にあたってのヒント
- 種別の記述
  - 類似の情報が複数あるときに、それらの情報を区別して扱う場合は種別プロパティ(xsd:string)を使ってその違いを記述します。
  - 情報の区分がコードとして用意されている場合は、種別コードプロパティ([コード型](#コード型))を使って記述します。詳しくは[コード型](#コード型)を参照ください。

- メタデータに関する記述
  - 記述対象に関する情報ではなく、その情報を誰がいつ記述したのかといった、記述している情報自体に関する情報をメタデータと言います。このようなメタデータを書きたいときは、メタデータプロパティ([文書型](#文書型))を使います。
    - 情報の作成者を書くときは、文書型の作成者プロパティ([実体型](#実体型))の値型に[人型](#人型)を型制約として指定し、人型の先の氏名プロパティ([氏名型](#氏名型))の先の姓名プロパティ(xsd:string)に作成者の名前を記述します。
    - 情報に対する様々な日付を書くときは、文書型の日付プロパティ([日付型](#日付型))を使って記述します。
      - 例えば"作成日"を書きたい場合は、日付プロパティの先の標準型日付プロパティ(xsd:date)に日付を記述し、種別プロパティ(xsd:string)に"作成日"と記述します。
    - 情報の権利について書くときは、文書型の権利管理プロパティ([文書型](#文書型))の先の表記プロパティ(xsd:string)に権利の名称を、参照プロパティ([参照型](#参照型))を使って典拠となる外部の情報を記述します。
    - 詳しくは[文書型](#文書型)を参照ください。

### [期間スケジュール型](#期間スケジュール型)
#### 概要
期間やスケジュールを記述するために用意された抽象的な型です。期間スケジュール型は[期間型](#期間型)や[イベントスケジュール型](#イベントスケジュール型)の上位の型(共通の親に当たる型)としての役割を持ち、この型を直接使って何かの情報を記述することはありません。

コア語彙でこの型がプロパティの値型として指定されている場合は、記述する対象に応じて期間型、イベントスケジュール型、もしくはこれらを継承した型などを型制約として指定して使うとよいでしょう。

この型の上位は[概念型](#概念型)です。この型では、概念型で用意されたプロパティも使われます。詳しくは[概念型](#概念型)を参照してください。

### [制約型](#制約型)
#### 概要
イベント、サービス、統計データ等の条件などにおいて、対象とその条件範囲等を制約として記述するために用意された抽象的な型です。制約型は[コード制約型](#コード制約型)、[範囲制約型](#範囲制約型)、[期間制約型](#期間制約型)の上位の型(共通の親に当たる型)としての役割を持ち、この型を直接使って何かの情報を記述することはありません。

コア語彙でこの型がプロパティの値型として指定されている場合は、記述する対象に応じてコード制約型、範囲制約型、期間制約型、もしくはこれらを継承した型などを型制約として指定して使うとよいでしょう。

この型の上位は[概念型](#概念型)です。この型では、概念型で用意されたプロパティも使われます。詳しくは[概念型](#概念型)を参照してください。

### [事物型](#事物型)
#### 概要
識別可能(個別にさし示すことが可能)な「こと」や「もの」の情報全般を記述するために用意された抽象的な型です。事物型はイベント等の「こと」的情報を記述する[イベント型](#イベント型)や、人、組織、製品といった「もの」的情報を記述する[人型](#人型)、[組織型](#組織型)、[製品型](#製品型)などに共通する上位の型(共通の親に当たる型)としての役割を持ち、この型を直接使って何かの情報を記述することはありません。

この型の上位は[概念型](#概念型)です。この型では、概念型で用意されたプロパティも使われます。詳しくは[概念型](#概念型)を参照してください。

#### 利用にあたってのヒント
- IDの記述
  - 記述する事物のIDを書く場合は、IDプロパティ([ID型](#id型))を使います。
  - ID型を使って、IDの値を書くときはIDプロパティの先の識別値プロパティ(xsd:string)に記述します。
  - そのIDがどのようなID体系のものであるかを明示するときは、IDプロパティの先の体系プロパティの先の表記プロパティ(xsd:string)もしくは種別プロパティ(xsd:string)にID体系の名称を記述します。詳しくは[ID型](#id型)を参照ください。
  - 複数のIDプロパティを使って、複数のIDを記述することができます。
  - 記述する事物には出来るだけIDを付与することを推奨します。
  - IDはひとまとまりのデータや一つの表の中でユニークなものであることが求められますが、できれば管理する情報全体でユニークになるように決める方が、その後の管理が楽になります。
    - 例えば、表にユニークなIDを振り、そのIDと表中のユニークなIDを結合して新たなIDを生成すれば、管理する情報全体でユニークなIDになります。
  - 管理する情報全体の中で複数箇所で出現する事物はそれが同一の事物であることがわかるように、同じIDをつけます。
    - そのような事物は予め調べておくよいでしょう。そのような事物を管理している表がある場合、その表におけるIDを使って、他での事物の出現の時にそのIDを使うとよいでしょう。そのような表がない場合、その事物とそのIDを管理する表を別途、作成しておくと、あとあと管理が楽になります。
  - IDの付与においては、削除はあっても、削除したIDの再利用はしてはいけません。IDの付与ルール作成においては、将来の変動を考慮において余裕ある付与ルールにしましょう。

- 表記の記述
  - 事物の名称や名前を文字列で書くときには、表記プロパティ(xsd:string)に記述します。
  - 事物を対象とした全ての型に表記プロパティがあるので、どの事物であってもこのプロパティで名称や名前を記述できます。
  - ただし、より詳細に名称や名前を記述したいときは名称プロパティ([名称型](#名称型))を使って記述します。名称プロパティは事物型の下位にある以下の型で用意されています。
    - [連絡先型](#連絡先型) / [組織型](#組織型) / [場所型](#場所型) / [ID体系型](#id体系型) / [製品型](#製品型) / [設備型](#設備型) / [イベント型](#イベント型) / [活動型](#活動型) / [状況型](#状況型) / [コードリスト型](#コードリスト型) / [サービス型](#サービス型)

- 外部Webページや画像の記述
  - 事物に関連するWebページを示すときは、参照プロパティ([参照型](#参照型))の先の参照先プロパティ(xsd:anyURI)に具体的なURLを記述します。詳しくは[参照型](#参照型)を参照ください。
  - 事物を代表する画像を示すときは、画像プロパティ(xsd:anyURI)に具体的なURLを記述します。

- 説明の記述
  - 簡単に事物の説明を書くときは、説明プロパティ(xsd:string)に記述します。
  - 事物に意味や役割の違う複数の説明があるときは、記述プロパティ([記述型](#記述型))を使います。
  - 記述型で説明を書くときは、種別プロパティ(xsd:string)にこの説明のタイトルや役割などを記述し、説明プロパティ(xsd:string)に説明文を記述します。

### [実体型](#実体型)
#### 概要
人や組織といった社会に存在する主体的な事物を記述するために用意された抽象的な型です。実体型は[人型](#人型)と[組織型](#組織型)の上位の型(共通の親に当たる型)としての役割を持ち、この型を直接使って何かの情報を記述することはありません。  
コア語彙でこの型がプロパティの値型として指定されている場合は、記述する対象に応じてこれらを継承した型などを型制約として指定して使うとよいでしょう。

この型の上位は[事物型](#事物型)です。また、その上位は[概念型](#概念型)です。この型では、事物型、概念型で用意されたプロパティも使われます。詳しくは[事物型](#事物型)、[概念型](#概念型)を参照してください。

#### 利用にあたってのヒント
- 関係している人や組織の記述
  - 人や組織が他の人や組織と持っている関係を書きたいときは、関与プロパティ([関与型](#関与型))を使います。
  - 関与型には役割プロパティ(xsd:string)と関与者プロパティ([実体型](#実体型))があります。役割プロパティに関係の説明を記述し、関与者プロパティに関係する人や組織を記述します。
    - 関与者プロパティの値型は実体型ですが、実際にはその継承で作られている[人型](#人型)や[組織型](#組織型)を型制約として指定して使います。
  - 複数の人や組織との関係を書くときは、関与プロパティを複数回使いその先の役割プロパティ(xsd:string)の値を変えることで記述します。
    - 例えば、組織が親会社と子会社を持っているとき、一方の関与プロパティではその先の役割プロパティに"親会社"と記述し、もう一方の関与プロパティではその先の役割プロパティに"子会社"と記述することで、各関与プロパティの役割を区別します。詳しくは[関与型](#関与型)を参照ください。
