DROP TABLE IF EXISTS "コア語彙" CASCADE;
CREATE TABLE "コア語彙" ("主語" TEXT, "述語" TEXT, "目的語" TEXT);

--

DROP FUNCTION IF EXISTS "コア語彙検索"(text, integer);
CREATE FUNCTION "コア語彙検索"(text, integer) RETURNS
 TABLE("主語" TEXT, "述語" TEXT, "目的語" TEXT, "パス" TEXT[],"階層" TEXT ) AS $$
WITH RECURSIVE "一次結果"("主語", "述語", "目的語", "パス") AS
(SELECT "主語" ,"述語", "目的語", ARRAY["主語"] FROM "コア語彙" WHERE "主語" = $1
  UNION ALL
 SELECT コア語彙."主語", コア語彙."述語", コア語彙."目的語", result."パス" || コア語彙."主語"
  FROM "一次結果" AS result,"コア語彙" AS コア語彙 WHERE result."目的語" = コア語彙."主語"
   AND コア語彙."目的語" != ALL(result."パス"))
 SELECT "主語", "述語", "目的語", "パス",ARRAY_UPPER("パス", 1)::TEXT AS "階層" FROM "一次結果" WHERE ARRAY_UPPER("パス", 1) <= $2;
$$ LANGUAGE SQL;

--

--goidb=# SELECT "コア語彙検索"("主語",5) FROM "コア語彙"  WHERE "主語" = 'ic:氏名';
                         コア語彙検索
---------------------------------------------------------------
-- (ic:氏名,property,ic:氏名型,{ic:氏名},1)
-- (ic:氏名型,class,ic:事物型,"{ic:氏名,ic:氏名型}",2)
-- (ic:事物型,class,ic:概念型,"{ic:氏名,ic:氏名型,ic:事物型}",3)
-- (3 行)


--
SELECT "コア語彙検索"("主語",5) FROM "コア語彙"  WHERE "主語" = 'ic:氏名型' GROUP BY "コア語彙検索"("主語",5);

